/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.dict;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.CRC32;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.ColumnDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.IndexDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.PrimaryKeyDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.TableGrantDesc;

@Deprecated
public class TableDesc
implements Serializable {
    private static final long serialVersionUID = -8904163472086670246L;
    private String m_name;
    private String m_owner;
    private String m_internalShortName;
    private HashMap<String, ColumnDesc> m_columns;
    private Collection<TableGrantDesc> m_grants;
    private Collection<IndexDesc> m_indices;
    private PrimaryKeyDesc m_pk;

    private TableDesc() {
    }

    public TableDesc(String name, String owner) {
        this.m_name = name;
        this.m_owner = owner;
        this.m_columns = new HashMap();
        this.m_indices = new HashSet<IndexDesc>();
        this.m_grants = new HashSet<TableGrantDesc>();
        this.rebuildInternalShortName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getFullName() {
        return String.valueOf(this.m_owner) + "." + this.m_name;
    }

    public String getInternalShortName() {
        return this.m_internalShortName;
    }

    public List<ColumnDesc> getColumns() {
        return new ArrayList<ColumnDesc>(this.m_columns.values());
    }

    public ColumnDesc getColumn(String name) {
        return this.m_columns.get(name);
    }

    public void addColumn(ColumnDesc cd) {
        this.m_columns.put(cd.getName(), cd);
    }

    public Collection<IndexDesc> getIndices() {
        return this.m_indices;
    }

    public void addIndex(IndexDesc id) {
        this.m_indices.add(id);
    }

    public Collection<TableGrantDesc> getGrants() {
        return this.m_grants;
    }

    public void addGrant(TableGrantDesc gd) {
        this.m_grants.add(gd);
    }

    public PrimaryKeyDesc getPrimaryKey() {
        return this.m_pk;
    }

    public void setPrimaryKey(PrimaryKeyDesc pk) {
        this.m_pk = pk;
    }

    public String toXml() {
        StringBuffer buf = new StringBuffer();
        buf.append("<table name=\"" + this.getName() + "\">\n");
        buf.append("<columns>\n");
        for (ColumnDesc cd : this.m_columns.values()) {
            buf.append(cd.toXml());
        }
        buf.append("</columns>\n");
        if (this.m_pk != null) {
            buf.append(this.m_pk.toXml());
        }
        buf.append("<indexes>\n");
        for (IndexDesc id : this.m_indices) {
            buf.append(id.toXml());
        }
        buf.append("</indexes>\n");
        buf.append("<grants>\n");
        for (TableGrantDesc gd : this.m_grants) {
            buf.append(gd.toXml());
        }
        buf.append("</grants>\n");
        buf.append("</table>\n");
        return buf.toString();
    }

    private void rebuildInternalShortName() {
        this.m_internalShortName = TableDesc.createInternalShortName(this.m_name);
    }

    public static String createInternalShortName(String name) {
        String s = name;
        if (s.length() > 25) {
            CRC32 crc = new CRC32();
            crc.update(s.getBytes());
            s = String.valueOf(s.substring(0, 21)) + Integer.toHexString((int)(crc.getValue() & 0xFFFFL));
        }
        return s;
    }

    public static String removeOwner(String fullName) {
        String s = fullName;
        int i = s.indexOf(46);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        return s;
    }
}

