/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.SwingConstants;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;

public class FlowLayoutEx
extends AbstractLayoutManager2
implements SwingConstants {
    private int m_align;
    private int m_hgap;
    private int m_vgap;
    private int m_orientation;
    private boolean m_fillHorizontal;
    private boolean m_fillVertical;
    private Component[] m_visibleComponents;
    private Dimension[][] m_visibleComponentSizes;
    private int m_preferredSpan;

    public FlowLayoutEx() {
        this(0, 5, 5);
    }

    public FlowLayoutEx(int align) {
        this(align, 5, 5);
    }

    public FlowLayoutEx(int align, int hgap, int vgap) {
        this(0, align, hgap, vgap);
    }

    public FlowLayoutEx(int orientation, int align, int hgap, int vgap) {
        this.m_orientation = orientation == 1 ? orientation : 0;
        this.m_hgap = hgap;
        this.m_vgap = vgap;
        this.m_align = align;
    }

    public int getAlignment() {
        return this.m_align;
    }

    public void setAlignment(int align) {
        this.m_align = align;
    }

    public int getHgap() {
        return this.m_hgap;
    }

    public void setHgap(int hgap) {
        this.m_hgap = hgap;
    }

    public int getVgap() {
        return this.m_vgap;
    }

    public void setVgap(int vgap) {
        this.m_vgap = vgap;
    }

    public boolean isFillHorizontal() {
        return this.m_fillHorizontal;
    }

    public void setFillHorizontal(boolean fillHorizontal) {
        this.m_fillHorizontal = fillHorizontal;
    }

    public boolean isFillVertical() {
        return this.m_fillVertical;
    }

    public void setFillVertical(boolean fillVertical) {
        this.m_fillVertical = fillVertical;
    }

    @Override
    protected void validateLayout(Container parent) {
        ArrayList<Component> visibleComponents = new ArrayList<Component>();
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                visibleComponents.add(c);
            }
            ++i;
        }
        this.m_visibleComponents = visibleComponents.toArray(new Component[visibleComponents.size()]);
        this.m_visibleComponentSizes = new Dimension[this.m_visibleComponents.length][3];
        this.m_preferredSpan = 0;
        i = 0;
        while (i < this.m_visibleComponents.length) {
            this.m_visibleComponentSizes[i] = SwingLayoutUtility.getValidatedSizes(this.m_visibleComponents[i]);
            if (this.m_orientation == 0) {
                if (i > 0) {
                    this.m_preferredSpan += this.m_hgap;
                }
                this.m_preferredSpan += this.m_visibleComponentSizes[i][1].width;
            } else {
                if (i > 0) {
                    this.m_preferredSpan += this.m_vgap;
                }
                this.m_preferredSpan += this.m_visibleComponentSizes[i][1].height;
            }
            ++i;
        }
    }

    @Override
    protected Dimension getLayoutSize(Container parent, int sizeflag) {
        Dimension dim = new Dimension(0, 0);
        if (this.m_visibleComponents.length > 0) {
            int i = 0;
            while (i < this.m_visibleComponents.length) {
                Dimension d = this.m_visibleComponentSizes[i][sizeflag];
                if (this.m_orientation == 0) {
                    dim.height = Math.max(dim.height, d.height);
                    if (i > 0) {
                        dim.width += this.m_hgap;
                    }
                    dim.width += d.width;
                } else {
                    dim.width = Math.max(dim.width, d.width);
                    if (i > 0) {
                        dim.height += this.m_vgap;
                    }
                    dim.height += d.height;
                }
                ++i;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.verifyLayout(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension[] sizes;
            if (!SwingUtility.IS_JAVA_7_OR_GREATER) {
                SwingUtility.setZeroBounds(parent.getComponents());
            } else {
                Component[] componentArray = parent.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    Rectangle r = c.getBounds();
                    c.setBounds(r.x, r.y, 0, 0);
                    ++n2;
                }
            }
            int n = this.m_visibleComponents.length;
            Insets insets = parent.getInsets();
            int w = parent.getWidth() - (insets.left + insets.right);
            int h = parent.getHeight() - (insets.top + insets.bottom);
            if (this.m_orientation == 0) {
                sizes = this.calculateHorizontalSizes(parent, w);
                int usedSpan = 0;
                Dimension[] dimensionArray = sizes;
                int n3 = sizes.length;
                int n4 = 0;
                while (n4 < n3) {
                    Dimension d = dimensionArray[n4];
                    usedSpan += d.width;
                    ++n4;
                }
                usedSpan += Math.max(n - 1, 0) * this.m_hgap;
                int x = insets.left;
                int y = insets.top;
                if (this.m_align != 2) {
                    x = this.m_align == 0 ? (x += Math.max(0, (w - usedSpan) / 2)) : (x += Math.max(0, w - usedSpan));
                }
                int i = 0;
                while (i < n) {
                    Component m = this.m_visibleComponents[i];
                    int netHeight = this.isFillVertical() ? h : Math.min(h, sizes[i].height);
                    m.setBounds(x, y, sizes[i].width, netHeight);
                    x += sizes[i].width + this.m_hgap;
                    ++i;
                }
            } else {
                sizes = this.calculateVerticalSizes(parent, h);
                int usedSpan = 0;
                Object m = sizes;
                int i = sizes.length;
                int y = 0;
                while (y < i) {
                    Dimension d = m[y];
                    usedSpan += d.height;
                    ++y;
                }
                usedSpan += Math.max(n - 1, 0) * this.m_vgap;
                int x = insets.left;
                y = insets.top;
                if (this.m_align != 1) {
                    y = this.m_align == 0 ? (y += Math.max(0, (h - usedSpan) / 2)) : (y += Math.max(0, h - usedSpan));
                }
                i = 0;
                while (i < n) {
                    m = this.m_visibleComponents[i];
                    int netWidth = this.isFillHorizontal() ? w : Math.min(w, sizes[i].width);
                    ((Component)m).setBounds(x, y, netWidth, sizes[i].height);
                    y += sizes[i].height + this.m_vgap;
                    ++i;
                }
            }
        }
    }

    private Dimension[] calculateHorizontalSizes(Container parent, int widthInclusiveGaps) {
        int n = this.m_visibleComponents.length;
        int netWidth = widthInclusiveGaps - Math.max(n - 1, 0) * this.m_hgap;
        Dimension[] sizes = new Dimension[n];
        if (this.m_preferredSpan <= netWidth) {
            if (this.isFillHorizontal()) {
                int w;
                Dimension max;
                int weights = 0;
                int pixels = netWidth - this.m_preferredSpan;
                int i = 0;
                while (i < n) {
                    Dimension pref = this.m_visibleComponentSizes[i][1];
                    max = this.m_visibleComponentSizes[i][2];
                    w = Math.max(0, max.width - pref.width);
                    weights += w;
                    ++i;
                }
                i = 0;
                while (i < n) {
                    Dimension d = this.m_visibleComponentSizes[i][1].getSize();
                    max = this.m_visibleComponentSizes[i][2];
                    w = Math.max(0, max.width - d.width);
                    if (weights > 0) {
                        int dPix = pixels * w / weights;
                        d.width += dPix;
                        pixels -= dPix;
                        weights -= w;
                    }
                    sizes[i] = d;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < n) {
                    Dimension d;
                    sizes[i] = d = this.m_visibleComponentSizes[i][1].getSize();
                    ++i;
                }
            }
        } else {
            int w = 0;
            int i = 0;
            while (i < n) {
                Dimension d = this.m_visibleComponentSizes[i][0].getSize();
                d.width = Math.min(d.width, netWidth / n);
                sizes[i] = d;
                w += d.width;
                ++i;
            }
            i = 0;
            while (i < n && w < netWidth) {
                int growPotential = Math.max(0, this.m_visibleComponentSizes[i][1].width - sizes[i].width);
                int consumed = Math.min(netWidth - w, growPotential);
                if (consumed > 0) {
                    sizes[i].width += consumed;
                    w += consumed;
                }
                ++i;
            }
        }
        return sizes;
    }

    private Dimension[] calculateVerticalSizes(Container parent, int heightInclusiveGaps) {
        int n = this.m_visibleComponents.length;
        int netHeight = heightInclusiveGaps - Math.max(n - 1, 0) * this.m_vgap;
        Dimension[] sizes = new Dimension[n];
        if (this.m_preferredSpan <= netHeight) {
            if (this.isFillVertical()) {
                int h;
                Dimension max;
                int weights = 0;
                int pixels = netHeight - this.m_preferredSpan;
                int i = 0;
                while (i < n) {
                    Dimension pref = this.m_visibleComponentSizes[i][1];
                    max = this.m_visibleComponentSizes[i][2];
                    h = Math.max(0, max.height - pref.height);
                    weights += h;
                    ++i;
                }
                i = 0;
                while (i < n) {
                    Dimension d = this.m_visibleComponentSizes[i][1].getSize();
                    max = this.m_visibleComponentSizes[i][2];
                    h = Math.max(0, max.height - d.height);
                    if (weights > 0) {
                        int dPix = pixels * h / weights;
                        d.height += dPix;
                        pixels -= dPix;
                        weights -= h;
                    }
                    sizes[i] = d;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < n) {
                    Dimension d;
                    sizes[i] = d = this.m_visibleComponentSizes[i][1].getSize();
                    ++i;
                }
            }
        } else {
            int h = 0;
            int i = 0;
            while (i < n) {
                Dimension d = this.m_visibleComponentSizes[i][0].getSize();
                d.height = Math.min(d.height, netHeight / n);
                sizes[i] = d;
                h += d.height;
                ++i;
            }
            i = 0;
            while (i < n && h < netHeight) {
                int growPotential = Math.max(0, this.m_visibleComponentSizes[i][1].height - sizes[i].height);
                int consumed = Math.min(netHeight - h, growPotential);
                if (consumed > 0) {
                    sizes[i].height += consumed;
                    h += consumed;
                }
                ++i;
            }
        }
        return sizes;
    }
}

