/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.HyperlinkBorder;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;

public class JHyperlink
extends JLabelEx {
    private static final long serialVersionUID = 1L;

    public JHyperlink(String text) {
        this();
        this.setText(text);
    }

    public JHyperlink() {
        this.setOpaque(false);
        this.setBorder(new HyperlinkBorder());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setAlignmentX(0.5f);
        this.setCursor(Cursor.getPredefinedCursor(12));
        SwingUtility.installDefaultFocusHandling(this);
        this.setName("Synth.Hyperlink");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("SPACE"), "action");
        this.getActionMap().put("action", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JHyperlink.this.fireActionPerformed();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JHyperlink.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JHyperlink.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mouseEntered(MouseEvent e) {
                JHyperlink.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JHyperlink.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
                if (JHyperlink.this.isRequestFocusEnabled()) {
                    JHyperlink.this.requestFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix.mouseClicked()) {
                    return;
                }
                if (e.getClickCount() == 1) {
                    JHyperlink.this.fireActionPerformed();
                }
            }
        });
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = new ActionEvent(this, 1001, null, EventQueue.getMostRecentEventTime(), modifiers);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }
}

