/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class PopupFactoryEx
extends PopupFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PopupFactoryEx.class);
    private static final PopupFactoryEx CUSTOM_POPUP_FACTORY = new PopupFactoryEx();
    private static final PopupFactory ORIGINAL_POPUP_FACTORY = PopupFactoryEx.getSharedInstance();
    private static final AtomicInteger COUNTER = new AtomicInteger();

    private PopupFactoryEx() {
    }

    public static void activate() {
        if (COUNTER.incrementAndGet() == 1) {
            LOG.debug("Activate custom popup factory to ensure, all swing components are validated before displaying a popup.");
            PopupFactoryEx.setSharedInstance(CUSTOM_POPUP_FACTORY);
        } else {
            LOG.debug("Custom popup factory already active, counter was incremented.");
        }
    }

    public static void deactivate() {
        if (COUNTER.decrementAndGet() <= 0) {
            LOG.debug("Deactivate custom popup factory.");
            PopupFactoryEx.setSharedInstance(ORIGINAL_POPUP_FACTORY);
        } else {
            LOG.debug("There are still awt/swt components displayed, counter was decremented.");
        }
    }

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        Component root = SwingUtilities.getRoot(owner);
        if (root != null) {
            root.validate();
        }
        return super.getPopup(owner, contents, x, y);
    }
}

