/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.extension;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.extension.IFormFieldExtension;
import org.eclipse.scout.rt.ui.swing.extension.internal.FormFieldExtension;

public final class FormFieldsExtensionPoint {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FormFieldsExtensionPoint.class);

    private FormFieldsExtensionPoint() {
    }

    public static IFormFieldExtension[] getFormFieldExtensions() {
        IExtension[] extensions;
        ArrayList<FormFieldExtension> formFieldExtensionList = new ArrayList<FormFieldExtension>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.rt.ui.swing", "formfields");
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String name = element.getAttribute("name");
                boolean active = "true".equalsIgnoreCase(element.getAttribute("active"));
                FormFieldExtension formFieldExt = new FormFieldExtension(name);
                formFieldExt.setContibuterBundleId(extension.getContributor().getName());
                formFieldExt.setActive(active);
                formFieldExt.setScope(FormFieldsExtensionPoint.getScopePriority(element.getAttribute("scope")));
                formFieldExt.setModelClassName(element.getAttribute("modelClass"));
                formFieldExt.setFactoryClassName(FormFieldsExtensionPoint.getClassName(element.getChildren("factory"), "class"));
                formFieldExt.setUiClassName(FormFieldsExtensionPoint.getClassName(element.getChildren("uiClass"), "class"));
                formFieldExtensionList.add(formFieldExt);
                ++n4;
            }
            ++n2;
        }
        return formFieldExtensionList.toArray(new IFormFieldExtension[formFieldExtensionList.size()]);
    }

    private static String getClassName(IConfigurationElement[] elements, String attribute) {
        String clazzName = null;
        if (elements != null && elements.length == 1) {
            clazzName = elements[0].getAttribute(attribute);
        }
        return clazzName;
    }

    private static int getScopePriority(String scope) {
        int prio = 0;
        if (StringUtility.isNullOrEmpty((CharSequence)scope) || "default".equalsIgnoreCase(scope)) {
            prio = 0;
        } else if ("global".equalsIgnoreCase(scope)) {
            prio = 1;
        }
        return prio;
    }
}

