/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompositeIcon
implements Icon {
    private int m_gap;
    private Icon[] m_icons;
    private int m_paintedX;
    private int w;
    private int h;

    public CompositeIcon(int gap, Icon ... icons) {
        this.m_gap = gap;
        this.m_icons = icons;
        this.w = 0;
        this.h = 0;
        int index = 0;
        Icon[] iconArray = this.m_icons;
        int n = this.m_icons.length;
        int n2 = 0;
        while (n2 < n) {
            Icon icon = iconArray[n2];
            if (icon != null) {
                if (index > 0) {
                    this.w += this.m_gap;
                }
                this.w += icon.getIconWidth();
                this.h = Math.max(this.h, icon.getIconHeight());
                ++index;
            }
            ++n2;
        }
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.m_paintedX = x;
        int offsetX = 0;
        int index = 0;
        Icon[] iconArray = this.m_icons;
        int n = this.m_icons.length;
        int n2 = 0;
        while (n2 < n) {
            Icon icon = iconArray[n2];
            if (icon != null) {
                if (index > 0) {
                    if (this.m_gap > 0) {
                        g.setColor(Color.lightGray);
                        g.drawLine(x + offsetX + this.m_gap / 2, y, x + offsetX + this.m_gap / 2, this.w + this.h);
                    }
                    offsetX += this.m_gap;
                }
                int offsetY = Math.max(0, (this.h - icon.getIconHeight()) / 2);
                icon.paintIcon(c, g, x + offsetX, offsetY + y);
                offsetX += icon.getIconWidth();
                ++index;
            }
            ++n2;
        }
    }

    public int getIconIndexFor(int x) {
        int offsetX = 0;
        if ((x -= this.m_paintedX) < 0) {
            return this.m_icons.length > 0 ? 0 : -1;
        }
        int i = 0;
        while (i < this.m_icons.length) {
            if (this.m_icons[i] != null) {
                if (x >= offsetX && x <= offsetX + this.m_icons[i].getIconWidth()) {
                    return i;
                }
                offsetX += this.m_icons[i].getIconWidth();
                offsetX += this.m_gap;
            }
            ++i;
        }
        return this.m_icons.length - 1;
    }
}

