/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.popup;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;

public class SwtScoutPopup
implements ISwtScoutPart {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutPopup.class);
    public static final String PROP_POPUP_OWNER = "propPopupOwner";
    private ISwtEnvironment m_env;
    private Control m_ownerComponent;
    private Shell m_shell;
    private Composite m_shellContentPane;
    private IForm m_scoutForm;
    private boolean m_positionBelowReferenceField;
    private boolean m_popupOnField;
    private int m_widthHint;
    private int m_heightHint;
    private int m_maxHeightHint;
    private int m_maxWidthHint;
    private ISwtScoutForm m_uiForm;
    private boolean m_takeFocusOnOpen = false;

    public SwtScoutPopup(ISwtEnvironment env, Control ownerComponent, boolean takeFocusOnOpen, int style) {
        this.m_env = env;
        this.m_takeFocusOnOpen = takeFocusOnOpen;
        if (!this.m_takeFocusOnOpen) {
            style |= 0x84000;
        }
        this.m_positionBelowReferenceField = true;
        this.m_ownerComponent = ownerComponent;
        this.m_widthHint = -1;
        this.m_heightHint = -1;
        this.m_maxHeightHint = -1;
        this.m_maxWidthHint = -1;
        this.m_shell = new Shell(ownerComponent.getShell(), style);
        this.m_shell.setData("extendedStyle", (Object)8);
        this.m_shell.setLayout((Layout)new FillLayout());
        this.m_shellContentPane = env.getFormToolkit().createComposite((Composite)this.m_shell, 0);
        this.m_shellContentPane.setLayout((Layout)new FillLayout());
    }

    @Override
    public void setBusy(boolean b) {
    }

    public Shell getShell() {
        return this.m_shell;
    }

    public void setBounds(Rectangle bounds) {
        this.getShell().setBounds(bounds);
        this.getShell().layout(true, true);
    }

    public void setPopupOnField(boolean popupOnField) {
        this.m_popupOnField = popupOnField;
    }

    public void setWidthHint(int widthHint) {
        this.m_widthHint = widthHint > 0 ? widthHint : -1;
    }

    public void setHeightHint(int heightHint) {
        this.m_heightHint = heightHint > 0 ? heightHint : -1;
    }

    public void setMaxHeightHint(int maxHeightHint) {
        this.m_maxHeightHint = maxHeightHint > 0 ? maxHeightHint : -1;
    }

    public void setMaxWidthHint(int maxWidthHint) {
        this.m_maxWidthHint = maxWidthHint > 0 ? maxWidthHint : -1;
    }

    public void showForm(IForm scoutForm) {
        if (this.m_scoutForm != null) {
            throw new IllegalStateException("The popup is already opened.");
        }
        this.m_scoutForm = scoutForm;
        this.m_uiForm = this.m_env.createForm(this.m_shellContentPane, scoutForm);
        this.autoAdjustBounds();
        if (this.m_takeFocusOnOpen) {
            this.m_shell.open();
        } else {
            this.m_shell.setVisible(true);
        }
        this.autoAdjustBounds();
        this.onPopupOpened();
    }

    @Override
    public void closePart() {
        if (!this.m_shell.isDisposed()) {
            this.m_shell.dispose();
            this.onPopupClosed();
        }
    }

    @Override
    public IForm getForm() {
        return this.m_scoutForm;
    }

    @Override
    public Form getSwtForm() {
        return null;
    }

    @Override
    public ISwtScoutForm getUiForm() {
        return this.m_uiForm;
    }

    public void autoAdjustBounds() {
        Rectangle alternateView;
        if (this.getShell().isDisposed()) {
            return;
        }
        if (this.m_ownerComponent.isDisposed()) {
            LOG.warn("Failed to adjust popup bounds because owner component is disposed");
            return;
        }
        Point dim = this.getShell().computeSize(this.m_widthHint, this.m_heightHint, true);
        dim.x = Math.max(dim.x, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutDefaultColumnWidth());
        if (this.m_maxWidthHint != -1) {
            dim.x = Math.min(dim.x, this.m_maxWidthHint);
        }
        if (this.m_maxHeightHint != -1) {
            dim.y = Math.min(dim.y, this.m_maxHeightHint);
        }
        Point p = this.m_ownerComponent.toDisplay(new Point(-this.m_ownerComponent.getBorderWidth(), 0));
        Point above = new Point(p.x, p.y);
        if (this.m_popupOnField) {
            above.y += this.m_ownerComponent.getBounds().height;
        }
        Rectangle aboveView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(above.x, above.y - dim.y, dim.x, dim.y), false, false);
        Point below = new Point(p.x, p.y);
        if (!this.m_popupOnField) {
            below.y += this.m_ownerComponent.getBounds().height;
        }
        Rectangle belowView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(below.x, below.y, dim.x, dim.y), false, false);
        Rectangle currentView = this.m_positionBelowReferenceField ? belowView : aboveView;
        Rectangle rectangle = alternateView = this.m_positionBelowReferenceField ? aboveView : belowView;
        if (currentView.height >= alternateView.height) {
            this.getShell().setBounds(currentView);
        } else {
            this.getShell().setBounds(alternateView);
            this.m_positionBelowReferenceField = !this.m_positionBelowReferenceField;
        }
    }

    public Composite getShellContentPane() {
        return this.m_shellContentPane;
    }

    public void addShellListener(ShellListener listener) {
        this.m_shell.addShellListener(listener);
    }

    public void removeShellListener(ShellListener listener) {
        this.m_shell.removeShellListener(listener);
    }

    @Override
    public boolean isVisible() {
        return !this.m_shell.isDisposed() && this.m_shell.getVisible();
    }

    @Override
    public void activate() {
        if (!this.m_shell.isDisposed()) {
            this.m_shell.setActive();
        }
    }

    @Override
    public boolean isActive() {
        return this.m_shell.isDisposed() && this.m_shell.getDisplay().getActiveShell() == this.m_shell;
    }

    @Override
    public void setStatusLineMessage(Image image, String message) {
    }

    protected void onPopupOpened() {
    }

    protected void onPopupClosed() {
        if (this.m_scoutForm != null) {
            this.m_env.invokeScoutLater(new Runnable(){

                @Override
                public void run() {
                    SwtScoutPopup.this.m_scoutForm.getUIFacade().fireFormKilledFromUI();
                }
            }, 0L);
        }
    }

    protected Control getOwnerComponent() {
        return this.m_ownerComponent;
    }
}

