/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractRenameExecutor;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service.AbstractServiceNodePage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class ServiceRenameExecutor
extends AbstractRenameExecutor {
    private IType m_serviceImplementation;
    private IType m_serviceInterface;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        boolean superRun = super.canRun(selection);
        if (!superRun) {
            return false;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof AbstractServiceNodePage) {
            AbstractServiceNodePage asnp = (AbstractServiceNodePage)selectedElement;
            this.m_serviceImplementation = asnp.getType();
            this.m_serviceInterface = asnp.getInterfaceType();
        }
        return this.isEditable((IJavaElement)this.m_serviceImplementation);
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        if (TypeUtility.exists((IJavaElement)this.m_serviceImplementation)) {
            transaction.add(this.m_serviceImplementation, newName);
        }
        String newInterfaceName = "I" + newName;
        if (TypeUtility.exists((IJavaElement)this.m_serviceInterface)) {
            transaction.add(this.m_serviceInterface, newInterfaceName);
        }
        final IScoutBundle interfaceBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_serviceInterface);
        final String oldFqn = this.m_serviceInterface.getFullyQualifiedName();
        final String newFqn = oldFqn.replace(this.m_serviceInterface.getElementName(), newInterfaceName);
        new OperationJob(new IOperation[]{new IOperation(){

            public void validate() {
            }

            public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
                IScoutBundleFilter filter = ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"})});
                for (IScoutBundle clientBundle : interfaceBundle.getChildBundles(filter, true)) {
                    String attribName = "class";
                    PluginModelHelper h = new PluginModelHelper(clientBundle.getProject());
                    HashMap<String, String> attributes = new HashMap<String, String>(1);
                    attributes.put(attribName, oldFqn);
                    List simpleExtensions = h.PluginXml.getSimpleExtensions("org.eclipse.scout.service.services", "proxy", attributes);
                    for (IPluginElement proxy : simpleExtensions) {
                        proxy.setAttribute(attribName, newFqn);
                    }
                    h.save();
                }
            }

            public String getOperationName() {
                return "Rename client proxies";
            }
        }}).schedule();
    }

    @Override
    protected IStatus validate(String newName) {
        String packName;
        IStatus inheritedStatus = ScoutUtility.validateJavaName((String)newName, (String)this.getReadOnlySuffix());
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (this.m_serviceImplementation != null && TypeUtility.existsType((String)(String.valueOf(packName = this.m_serviceImplementation.getPackageFragment().getElementName()) + "." + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.m_serviceInterface != null && TypeUtility.existsType((String)(String.valueOf(packName = this.m_serviceInterface.getPackageFragment().getElementName()) + ".I" + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return inheritedStatus;
    }
}

