/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.executor.IExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public final class ExecutorExtensionPoint {
    public static final String PROP_CURRENT_CATEGORY = "org.eclipse.scout.sdk.ui.propCurrentExecutorCategory";
    public static final IExecutor EMPTY_EXECUTOR = new IExecutor(){

        @Override
        public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
            return null;
        }

        @Override
        public boolean canRun(IStructuredSelection selection) {
            return true;
        }
    };
    public static final String DEFAULT_CATEGORY = "Default";
    public static final String EXTENSION_POINT_NAME = "executor";
    public static final String TAG_NAME_EXECUTOR = "executor";
    public static final String ATTRIB_NAME_CLASS = "class";
    public static final String ATTRIB_NAME_ID = "id";
    public static final String ATTRIB_NAME_CATEGORY = "category";
    public static final String ATTRIB_NAME_ACTIVE = "active";
    private static final Object LOCK = new Object();
    private static volatile Map<String, Map<String, Class<? extends IExecutor>>> executors = null;
    private static volatile Set<String> categories = null;
    private static volatile String curCategory = null;

    private ExecutorExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, Class<? extends IExecutor>>> getExecutors() {
        if (executors == null) {
            Object object = LOCK;
            synchronized (object) {
                if (executors == null) {
                    IExtension[] extensions;
                    HashMap<String, HashMap<String, Class>> tmp = new HashMap<String, HashMap<String, Class>>();
                    HashSet<String> tmpCats = new HashSet<String>();
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", "executor");
                    IExtension[] iExtensionArray = extensions = xp.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            if ("executor".equals(element.getName())) {
                                String clazz = StringUtility.trim((String)element.getAttribute(ATTRIB_NAME_CLASS));
                                String id = StringUtility.trim((String)element.getAttribute(ATTRIB_NAME_ID));
                                String category = StringUtility.trim((String)element.getAttribute(ATTRIB_NAME_CATEGORY));
                                String active = StringUtility.trim((String)element.getAttribute(ATTRIB_NAME_ACTIVE));
                                if (!StringUtility.isNullOrEmpty((CharSequence)clazz) && !StringUtility.isNullOrEmpty((CharSequence)id)) {
                                    if (StringUtility.isNullOrEmpty((CharSequence)active) || "true".equalsIgnoreCase(active)) {
                                        if (StringUtility.isNullOrEmpty((CharSequence)category)) {
                                            category = DEFAULT_CATEGORY;
                                        }
                                        tmpCats.add(category);
                                        String contribPlugin = element.getContributor().getName();
                                        Bundle bundle = Platform.getBundle((String)contribPlugin);
                                        if (bundle != null) {
                                            try {
                                                Class old;
                                                Class execClass = bundle.loadClass(clazz);
                                                HashMap<String, Class> map = (HashMap<String, Class>)tmp.get(id);
                                                if (map == null) {
                                                    map = new HashMap<String, Class>(3);
                                                    tmp.put(id, map);
                                                }
                                                if ((old = map.put(category, execClass)) != null) {
                                                    ScoutSdkUi.logWarning("There are multiple executors with the same category registered for id '" + id + "'.");
                                                }
                                            }
                                            catch (ClassNotFoundException e) {
                                                ScoutSdkUi.logError("Unable to load class '" + clazz + "'. Executor for id '" + id + "' will be skipped.", e);
                                            }
                                        } else {
                                            ScoutSdkUi.logError("Contributing bundle of executor '" + id + "' could not be found.");
                                        }
                                    }
                                } else {
                                    ScoutSdkUi.logError("Invalid executor extension from bundle '" + element.getContributor().getName() + "'. At least " + ATTRIB_NAME_CLASS + " and " + ATTRIB_NAME_ID + " must be specified.");
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    categories = CollectionUtility.hashSet(tmpCats);
                    executors = CollectionUtility.copyMap(tmp);
                }
            }
        }
        return executors;
    }

    public static Set<String> getAllCategories() {
        ExecutorExtensionPoint.getExecutors();
        return CollectionUtility.hashSet(categories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentCategory() {
        if (curCategory == null) {
            Object object = LOCK;
            synchronized (object) {
                if (curCategory == null) {
                    Set<String> allCategories = ExecutorExtensionPoint.getAllCategories();
                    for (String c : allCategories) {
                        if (DEFAULT_CATEGORY.equals(c)) continue;
                        curCategory = c;
                        break;
                    }
                    if (curCategory == null) {
                        curCategory = (String)CollectionUtility.firstElement(allCategories);
                    }
                }
            }
        }
        return curCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentCategory(String newCategory) {
        Object object = LOCK;
        synchronized (object) {
            ExecutorExtensionPoint.getExecutors();
            curCategory = categories.contains(newCategory) ? newCategory : DEFAULT_CATEGORY;
        }
    }

    public static IExecutor getExecutorFor(String id) {
        Map<String, Map<String, Class<? extends IExecutor>>> allExectutors = ExecutorExtensionPoint.getExecutors();
        Map<String, Class<? extends IExecutor>> executorsForId = allExectutors.get(id);
        if (executorsForId != null && !executorsForId.isEmpty()) {
            Class<? extends IExecutor> executorClass = executorsForId.get(ExecutorExtensionPoint.getCurrentCategory());
            if (executorClass == null) {
                executorClass = executorsForId.get(DEFAULT_CATEGORY);
            }
            if (executorClass != null) {
                try {
                    return executorClass.newInstance();
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("unable to create executor for id '" + id + "'.", e);
                }
            }
        }
        ScoutSdkUi.logWarning("No executor found for id '" + id + "'.");
        return EMPTY_EXECUTOR;
    }
}

