/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import java.util.EventListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.sdk.ui.dialog.ProductSelectionDialog;
import org.eclipse.scout.sdk.ui.fields.IProductSelectionListener;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.StyledTextEx;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProductSelectionField
extends TextField {
    private Button m_popupButton;
    private IFile m_productFile;
    private EventListenerList m_eventListeners;
    private OptimisticLock m_inputLock = new OptimisticLock();
    private final ITreeNode m_productTreeRoot;

    public ProductSelectionField(Composite parent, ITreeNode productTreeRoot) {
        super(parent);
        this.m_productTreeRoot = productTreeRoot;
        this.m_eventListeners = new EventListenerList();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_popupButton.setEnabled(enabled);
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        Label label = this.getLabelComponent();
        StyledTextEx text = this.getTextComponent();
        this.m_popupButton = new Button(parent, 0x800008);
        this.m_popupButton.setImage(ScoutSdkUi.getImage("down.gif"));
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile newFile;
                ProductSelectionDialog dialog = new ProductSelectionDialog(ProductSelectionField.this.getShell(), ProductSelectionField.this.getProductTreeRoot());
                dialog.setMultiSelectionMode(false);
                dialog.setProductSelectionRequired(true);
                if (dialog.open() == 0 && !CompareUtility.equals((Object)(newFile = dialog.getSelectedProductFile()), (Object)ProductSelectionField.this.getProductFile())) {
                    try {
                        if (ProductSelectionField.this.m_inputLock.acquire()) {
                            String representationStr = "";
                            if (newFile != null) {
                                representationStr = String.valueOf(newFile.getProject().getName()) + "/" + newFile.getProjectRelativePath();
                            }
                            ProductSelectionField.this.getTextComponent().setText(representationStr);
                        }
                    }
                    finally {
                        ProductSelectionField.this.m_inputLock.release();
                    }
                    ProductSelectionField.this.setProductFileInternal(newFile);
                }
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ProductSelectionField.this.m_inputLock.acquire()) {
                        IFile file;
                        String input = ProductSelectionField.this.getText();
                        Path p = new Path(input);
                        if (p.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)p)).exists()) {
                            ProductSelectionField.this.setProductFileInternal(file);
                            return;
                        }
                        ProductSelectionField.this.setProductFileInternal(null);
                    }
                }
                finally {
                    ProductSelectionField.this.m_inputLock.release();
                }
            }
        });
        parent.setTabList(new Control[]{text});
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(this.getLabelPercentage(), 0);
        labelData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 5);
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        textData.bottom = new FormAttachment(100, 0);
        text.setLayoutData(textData);
        FormData buttonData = new FormData(22, 22);
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    public ITreeNode getProductTreeRoot() {
        return this.m_productTreeRoot;
    }

    public void addProductSelectionListener(IProductSelectionListener listener) {
        this.m_eventListeners.add(IProductSelectionListener.class, (EventListener)listener);
    }

    public void removeProductSelectionListener(IProductSelectionListener listener) {
        this.m_eventListeners.remove(IProductSelectionListener.class, (EventListener)listener);
    }

    private void fireProductSelected(IFile productFile) {
        IProductSelectionListener[] iProductSelectionListenerArray = (IProductSelectionListener[])this.m_eventListeners.getListeners(IProductSelectionListener.class);
        int n = iProductSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProductSelectionListener l = iProductSelectionListenerArray[n2];
            try {
                l.productSelected(productFile);
            }
            catch (Exception t) {
                ScoutSdkUi.logError("error during listener notification.", t);
            }
            ++n2;
        }
    }

    public void setProductFile(IFile productFile) {
        this.m_productFile = productFile;
        if (!this.isDisposed()) {
            String text = "";
            if (productFile != null) {
                text = String.valueOf(productFile.getProject().getName()) + "/" + productFile.getProjectRelativePath();
            }
            try {
                if (this.m_inputLock.acquire()) {
                    this.getTextComponent().setText(text);
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
    }

    private void setProductFileInternal(IFile productFile) {
        if (!CompareUtility.equals((Object)this.m_productFile, (Object)productFile)) {
            this.setProductFile(productFile);
            this.fireProductSelected(this.m_productFile);
        }
    }

    public IFile getProductFile() {
        return this.m_productFile;
    }
}

