/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.export;

import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.export.IExportScoutProjectEntryHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.export.ExportScoutProjectEntry;

public final class ExportScoutProjectEntryExtensionPoint {
    public static final String EXTENSION_ID = "exportScoutProjectEntry";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ORDER = "order";
    public static final String ATTR_CLASS = "class";

    private ExportScoutProjectEntryExtensionPoint() {
    }

    public static ExportScoutProjectEntry[] getEntries() {
        IExtension[] extensions;
        TreeSet<ExportScoutProjectEntry> ret = new TreeSet<ExportScoutProjectEntry>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXTENSION_ID);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    String id = element.getAttribute(ATTR_ID);
                    String name = element.getAttribute(ATTR_NAME);
                    int order = ExportScoutProjectEntryExtensionPoint.getOrder(element.getAttribute(ATTR_ORDER));
                    String icon = element.getAttribute(ATTR_ICON);
                    IExportScoutProjectEntryHandler provider = (IExportScoutProjectEntryHandler)element.createExecutableExtension(ATTR_CLASS);
                    ret.add(new ExportScoutProjectEntry(id, name, order, icon, provider));
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("could not load class '" + element.getAttribute(ATTR_CLASS) + "'.", e);
                }
                ++n4;
            }
            ++n2;
        }
        return ret.toArray(new ExportScoutProjectEntry[ret.size()]);
    }

    private static int getOrder(String order) {
        if (!StringUtility.hasText((CharSequence)order)) {
            return 0;
        }
        if (order.matches("[0-9]*")) {
            return Integer.parseInt(order);
        }
        return 0;
    }
}

