/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.LookupCallNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.LookupCallNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class LookupCallTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_lookupCallHierarchy;

    public LookupCallTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"LookupCallTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("lookupCalls.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_lookupCallHierarchy != null) {
            this.m_lookupCallHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_lookupCallHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_lookupCallHierarchy != null) {
            this.m_lookupCallHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.LookupCallTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    protected void loadChildrenImpl() {
        IType iLookupCall = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupCall");
        if (this.m_lookupCallHierarchy == null) {
            this.m_lookupCallHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iLookupCall);
            this.m_lookupCallHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        ITypeFilter filter = ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle());
        Set lookupCallTypes = this.m_lookupCallHierarchy.getAllSubtypes(iLookupCall, filter, TypeComparators.getTypeNameComparator());
        for (IType type : lookupCallTypes) {
            new LookupCallNodePage(this, type);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(LookupCallNewAction.class);
    }
}

