/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.MenuTypeDialog;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.MenuTypeParsers;
import org.eclipse.scout.sdk.workspace.type.config.parser.MenuTypesConfig;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MenuTypePresenter
extends AbstractValuePresenter<MenuTypesConfig> {
    private Button m_chooserButton;
    private IPropertySourceParser<MenuTypesConfig> m_parser = new MenuTypeParsers();

    public MenuTypePresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, null);
    }

    public IPropertySourceParser<MenuTypesConfig> getParser() {
        return this.m_parser;
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootPane = this.getToolkit().createComposite(container);
        super.createContent(rootPane);
        this.m_chooserButton = this.getToolkit().createButton(rootPane, "", 8);
        this.m_chooserButton.setImage(ScoutSdkUi.getImage("magnifier.png"));
        this.m_chooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuTypePresenter.this.showDialog();
            }
        });
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.horizontalSpacing = 3;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        rootPane.setLayout((Layout)gLayout);
        this.getTextComponent().setLayoutData((Object)new GridData(1808));
        this.getTextComponent().setEditable(false);
        this.m_chooserButton.setLayoutData((Object)new GridData(22, 22));
        return rootPane;
    }

    private void showDialog() {
        MenuTypeDialog menuTypesDialog = new MenuTypeDialog(this.getContainer().getShell(), ((MenuTypesConfig)this.getCurrentSourceValue()).clone(), this.getMethod().getType());
        MenuTypesConfig menuTypesSpec = menuTypesDialog.openDialog();
        if (menuTypesSpec != null) {
            try {
                if (!CompareUtility.equals((Object)((MenuTypesConfig)this.getCurrentSourceValue()), (Object)menuTypesSpec)) {
                    this.storeValue(menuTypesSpec);
                }
            }
            catch (CoreException e1) {
                ScoutSdkUi.logWarning("could not parse menu types: " + menuTypesSpec, e1);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_chooserButton.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    @Override
    protected String formatDisplayValue(MenuTypesConfig value) throws CoreException {
        if (value == null) {
            return "";
        }
        return this.getParser().formatSourceValue((Object)value, null, null).replace(", ", "\r\n");
    }

    @Override
    protected MenuTypesConfig parseSourceInput(String input) throws CoreException {
        if ("".equals(input)) {
            return (MenuTypesConfig)this.getDefaultValue();
        }
        return (MenuTypesConfig)this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected MenuTypesConfig parseDisplayInput(String input) throws CoreException {
        return this.parseSourceInput(input);
    }

    @Override
    protected void storeValue(MenuTypesConfig value) throws CoreException {
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.getParser());
            updateOp.setValue((Object)value);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could update method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }
}

