/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.IPageFilterable;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ViewLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private Composite m_parent;
    private Font m_fontPlainItalic;
    private final IPageFilterable m_filterable;

    public ViewLabelProvider(Composite parent, IPageFilterable explorerPart) {
        this.m_parent = parent;
        this.m_filterable = explorerPart;
    }

    public String getText(Object obj) {
        if (obj instanceof IPage) {
            IPage p = (IPage)obj;
            IPageFilter filter = this.m_filterable.getPageFilter(p);
            if (filter == null || filter.isEmpty()) {
                return p.getName();
            }
            return String.valueOf(p.getName()) + " [" + filter.getFilterExpression() + "]";
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof AbstractPage) {
            AbstractPage p = (AbstractPage)obj;
            return p.getImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IPage) {
            IType t;
            IPage p = (IPage)element;
            if (p instanceof ITypePage && TypeUtility.exists((IJavaElement)(t = ((ITypePage)p).getType())) && t.isBinary()) {
                return ScoutSdkUi.getDisplay().getSystemColor(17);
            }
            IScoutBundle scoutBundle = p.getScoutBundle();
            if (scoutBundle != null && scoutBundle.isBinary()) {
                return ScoutSdkUi.getDisplay().getSystemColor(17);
            }
        }
        return null;
    }

    public Font getFont(Object element) {
        this.ensureFontCache();
        if (element instanceof IPage) {
            IPage p = (IPage)element;
            IPageFilter filter = this.m_filterable.getPageFilter(p);
            if (filter == null || filter.isEmpty()) {
                return null;
            }
            return this.m_fontPlainItalic;
        }
        return null;
    }

    private void ensureFontCache() {
        if (this.m_fontPlainItalic == null) {
            try {
                FontData[] d;
                Font f = this.m_parent.getFont();
                if (f != null && (d = f.getFontData()) != null && d.length > 0 && this.m_fontPlainItalic == null) {
                    this.m_fontPlainItalic = new Font(f.getDevice(), d[0].getName(), d[0].getHeight(), 2);
                }
            }
            catch (Exception t) {
                ScoutSdkUi.logWarning(t);
            }
        }
    }
}

