/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.selection.ScoutStructuredSelection;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractWorkspaceWizard
extends AbstractWizard
implements IWorkspaceWizard {
    private final Map<Double, IOperation> m_performFinishOperations = new TreeMap<Double, IOperation>();
    private ContinueOperation m_continueOperation;

    public AbstractWorkspaceWizard() {
        super(new AbstractScoutWizardPage[0]);
    }

    public Map<Double, IOperation> getPerformFinishOperations() {
        return new TreeMap<Double, IOperation>(this.m_performFinishOperations);
    }

    protected Map<Double, IOperation> getPerformFinishOperationsInternal() {
        return this.m_performFinishOperations;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection instanceof ScoutStructuredSelection) {
            this.m_continueOperation = ((ScoutStructuredSelection)selection).getContinueOperation();
        }
        if (this.m_continueOperation == null) {
            this.m_continueOperation = ContinueOperation.FINISH;
        }
    }

    public ContinueOperation getContinueOperation() {
        return this.m_continueOperation;
    }

    @Override
    public IOperation addAdditionalPerformFinishOperation(IOperation op, double orderNr) {
        return this.m_performFinishOperations.put(orderNr, op);
    }

    @Override
    public boolean removeAdditionalPerformFinishOperation(IOperation op) {
        boolean changed = false;
        Iterator<IOperation> it = this.m_performFinishOperations.values().iterator();
        while (it.hasNext()) {
            IOperation operation = it.next();
            if (!CompareUtility.equals((Object)operation, (Object)op)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void addPage(IWizardPage page) {
        if (!(page instanceof AbstractWorkspaceWizardPage)) {
            throw new IllegalArgumentException("Expecting an instance of '" + AbstractWorkspaceWizardPage.class.getName() + "'.");
        }
        super.addPage(page);
    }

    @Override
    public final boolean performFinish() {
        block3: {
            try {
                if (this.beforeFinish()) break block3;
                ScoutSdkUi.logInfo("Wizard '" + this.getWindowTitle() + "' before finish canceled.");
                return false;
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Wizard finished abnormally", e);
                return false;
            }
        }
        P_PerformFinishOperation performFinishOperation = new P_PerformFinishOperation(this.getShell().getDisplay());
        this.m_performFinishOperations.put(0.0, performFinishOperation);
        OperationJob job = new OperationJob(this.m_performFinishOperations.values());
        job.schedule();
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            boolean validPage = false;
            AbstractWorkspaceWizardPage bcPage = (AbstractWorkspaceWizardPage)page;
            try {
                validPage = bcPage.performFinish(monitor, workingCopyManager);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("exception during perfoming finish on wizard page '" + page.getClass().getName() + "'.", e);
                return false;
            }
            if (!validPage) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void postFinishDisplayThread() {
    }

    protected boolean beforeFinish() throws CoreException {
        return true;
    }

    public static enum ContinueOperation {
        ADD_SAME,
        ADD_OTHER,
        FINISH;

    }

    private final class P_PerformFinishOperation
    implements IOperation {
        private final Display m_display;

        private P_PerformFinishOperation(Display display) {
            this.m_display = display;
        }

        public String getOperationName() {
            String windowTitle = AbstractWorkspaceWizard.this.getWindowTitle();
            if (StringUtility.isNullOrEmpty((CharSequence)windowTitle)) {
                return this.getClass().getName();
            }
            return windowTitle;
        }

        public void validate() {
        }

        public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
            try {
                AbstractWorkspaceWizard.this.performFinish(monitor, workingCopyManager);
                this.m_display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractWorkspaceWizard.this.postFinishDisplayThread();
                    }
                });
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                ScoutSdkUi.logError("Exception during perfoming finish on wizard page '" + AbstractWorkspaceWizard.class.getName() + "'.", e);
            }
        }
    }
}

