/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.CachedPrimaryTypeHierarchy;
import org.eclipse.scout.sdk.util.internal.typecache.CachedTypeHierarchy;
import org.eclipse.scout.sdk.util.internal.typecache.ICacheableTypeHierarchyResult;
import org.eclipse.scout.sdk.util.internal.typecache.ProjectContextTypeHierarchyResult;
import org.eclipse.scout.sdk.util.internal.typecache.TypeHierarchy;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchyResult;
import org.eclipse.scout.sdk.util.typecache.IHierarchyCache;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.TypeHierarchyConstraints;

public final class HierarchyCache
implements IHierarchyCache {
    private static final HierarchyCache INSTANCE = new HierarchyCache();
    private final Map<Object, ICacheableTypeHierarchyResult> m_cachedHierarchyResults = new HashMap<Object, ICacheableTypeHierarchyResult>();

    public static HierarchyCache getInstance() {
        return INSTANCE;
    }

    private HierarchyCache() {
    }

    @Override
    public synchronized void dispose() {
        this.invalidateAll();
        this.m_cachedHierarchyResults.clear();
    }

    public synchronized List<ICacheableTypeHierarchyResult> getAllCachedHierarchies() {
        return this.getHierarchiesSafe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedTypeHierarchyResult getProjectContextTypeHierarchy(TypeHierarchyConstraints constraints) {
        ICacheableTypeHierarchyResult h = null;
        HierarchyCache hierarchyCache = this;
        synchronized (hierarchyCache) {
            h = this.m_cachedHierarchyResults.get(constraints);
            if (h != null && !TypeUtility.exists((IJavaElement)h.getBaseType())) {
                h.invalidate();
                this.m_cachedHierarchyResults.remove(constraints);
                h = null;
            }
            if (h == null) {
                h = new ProjectContextTypeHierarchyResult(constraints);
                this.m_cachedHierarchyResults.put(constraints, h);
            }
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedTypeHierarchy getTypeHierarchy(IType type) {
        if (!TypeUtility.exists((IJavaElement)type) || !type.getJavaProject().exists()) {
            throw new IllegalArgumentException("type does not exist!");
        }
        ICacheableTypeHierarchyResult hierarchy = null;
        HierarchyCache hierarchyCache = this;
        synchronized (hierarchyCache) {
            hierarchy = this.m_cachedHierarchyResults.get(type);
            if (!(hierarchy == null || TypeUtility.exists((IJavaElement)hierarchy.getBaseType()) && TypeUtility.exists((IJavaElement)hierarchy.getBaseType().getJavaProject()))) {
                hierarchy.invalidate();
                this.m_cachedHierarchyResults.remove(type);
                hierarchy = null;
            }
            if (hierarchy == null) {
                hierarchy = new CachedTypeHierarchy(type);
                this.m_cachedHierarchyResults.put(type, hierarchy);
            }
        }
        return (ICachedTypeHierarchy)((Object)hierarchy);
    }

    @Override
    public ICachedTypeHierarchy getPrimaryTypeHierarchy(IType type) {
        if (type != null && TypeUtility.exists((IJavaElement)type.getDeclaringType())) {
            throw new IllegalArgumentException("type '" + type.getFullyQualifiedName() + "' must be a primary type.");
        }
        return new CachedPrimaryTypeHierarchy(this.getTypeHierarchy(type));
    }

    synchronized void removeCachedHierarchy(IType type) {
        this.m_cachedHierarchyResults.remove(type);
    }

    synchronized void replaceCachedHierarchy(Object oldKey, Object newKey, ICacheableTypeHierarchyResult hierarchyToAdd) {
        this.m_cachedHierarchyResults.remove(oldKey);
        this.m_cachedHierarchyResults.put(newKey, hierarchyToAdd);
    }

    @Override
    public ITypeHierarchy getLocalTypeHierarchy(IRegion region) {
        try {
            return new TypeHierarchy(null, JavaCore.newTypeHierarchy((IRegion)region, null, null));
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                SdkUtilActivator.logWarning("could not build hierarchy of region '" + region + "'.", e);
            }
            return null;
        }
    }

    @Override
    public ITypeHierarchy getSupertypeHierarchy(IType type) {
        try {
            return new TypeHierarchy(type, type.newSupertypeHierarchy(null));
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not build super hierarchy '" + type.getFullyQualifiedName() + "'.", e);
            return null;
        }
    }

    @Override
    public synchronized void invalidateAll() {
        List<ICacheableTypeHierarchyResult> hierarchies = this.getHierarchiesSafe();
        for (ICacheableTypeHierarchyResult h : hierarchies) {
            if (!h.isCreated()) continue;
            h.invalidate();
        }
    }

    private synchronized List<ICacheableTypeHierarchyResult> getHierarchiesSafe() {
        return CollectionUtility.arrayList(this.m_cachedHierarchyResults.values());
    }

    private void handleTypeChange(IType t, ITypeHierarchy superTypeHierarchy) {
        if (superTypeHierarchy != null) {
            List<ICacheableTypeHierarchyResult> hierarchies = this.getHierarchiesSafe();
            Set<IType> superTypes = superTypeHierarchy.getAllSupertypes(t);
            for (ICacheableTypeHierarchyResult h : hierarchies) {
                if (!h.isCreated() || h.contains(t) == h.isTypeAccepted(t, superTypes)) continue;
                h.invalidate();
            }
        }
    }

    private void handleTypeRemoved(IType type) {
        List<ICacheableTypeHierarchyResult> hierarchies = this.getHierarchiesSafe();
        for (ICacheableTypeHierarchyResult h : hierarchies) {
            if (!h.isCreated() || !h.contains(type)) continue;
            h.invalidate();
        }
    }

    private void handleJavaElementRemoved(IJavaElement element) {
        if (element.getElementType() < 7) {
            List<ICacheableTypeHierarchyResult> hierarchies = this.getHierarchiesSafe();
            block0: for (ICacheableTypeHierarchyResult h : hierarchies) {
                if (!h.isCreated()) continue;
                if (TypeUtility.isAncestor(element, (IJavaElement)h.getBaseType())) {
                    h.invalidate();
                    continue;
                }
                for (IType candidate : h) {
                    if (!TypeUtility.isAncestor(element, (IJavaElement)candidate)) continue;
                    h.invalidate();
                    continue block0;
                }
            }
        } else if (element.getElementType() == 7) {
            this.handleTypeRemoved((IType)element);
        }
    }

    private void handleCompilationUnitChanged(ICompilationUnit icu) {
        if (!TypeUtility.exists((IJavaElement)icu)) {
            return;
        }
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)icu);
        try {
            ITypeHierarchy hierarchy = this.getLocalTypeHierarchy(region);
            if (hierarchy != null) {
                IType[] iTypeArray = icu.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    this.reqTypeChangedFromExternal(t, hierarchy);
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not find types in compilation unit '" + icu.getElementName() + "'.", e);
        }
    }

    private void reqTypeChangedFromExternal(IType type, ITypeHierarchy hierarchy) {
        this.handleTypeChange(type, hierarchy);
        try {
            IType[] iTypeArray = type.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType subType = iTypeArray[n2];
                this.reqTypeChangedFromExternal(subType, hierarchy);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not find subtypes of type '" + type.getElementName() + "'.", e);
        }
    }

    void elementChanged(JdtEvent e) {
        switch (e.getEventType()) {
            case 1: 
            case 4: {
                if (e.getElementType() == 7 && e.getDeclaringType() == null) {
                    this.handleTypeChange((IType)e.getElement(), e.getSuperTypeHierarchy());
                    break;
                }
                if (e.getElementType() == 5) {
                    this.handleCompilationUnitChanged((ICompilationUnit)e.getElement());
                    break;
                }
                if (e.getElementType() == 2) {
                    if ((e.getFlags() & 0x200) != 0 || e.getFlags() == 0) {
                        this.invalidateAll();
                        break;
                    }
                    if ((e.getFlags() & 0x400) == 0) break;
                    this.handleJavaElementRemoved(e.getElement());
                    break;
                }
                if (e.getElementType() != 3 || (e.getFlags() & 0x81C0) == 0 && e.getFlags() != 0) break;
                this.invalidateAll();
                break;
            }
            case 2: {
                if (!TypeUtility.exists(e.getElement().getParent())) break;
                this.handleJavaElementRemoved(e.getElement());
                break;
            }
            case 229: {
                if (e.getElementType() == 5) {
                    this.handleCompilationUnitChanged((ICompilationUnit)e.getElement());
                    break;
                }
                if (e.getElementType() != 7) break;
                this.handleTypeChange((IType)e.getElement(), e.getSuperTypeHierarchy());
            }
        }
    }
}

