/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.ICacheableTypeHierarchyResult;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.util.typecache.TypeHierarchyConstraints;

public final class ProjectContextTypeHierarchyResult
implements ICacheableTypeHierarchyResult {
    private final EventListenerList m_hierarchyListeners;
    private final TypeHierarchyConstraints m_constraints;
    private final IType m_baseType;
    private Set<IType> m_cachedTypes;

    ProjectContextTypeHierarchyResult(TypeHierarchyConstraints constraints) {
        if (constraints == null) {
            throw new IllegalArgumentException("no constraints specified for type hierarchy!");
        }
        this.m_hierarchyListeners = new EventListenerList();
        this.m_baseType = constraints.getBaseType();
        this.m_constraints = constraints;
        this.m_cachedTypes = null;
    }

    private void fireHierarchyChanged() {
        ITypeHierarchyChangedListener[] iTypeHierarchyChangedListenerArray = (ITypeHierarchyChangedListener[])this.m_hierarchyListeners.getListeners(ITypeHierarchyChangedListener.class);
        int n = iTypeHierarchyChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeHierarchyChangedListener l = iTypeHierarchyChangedListenerArray[n2];
            try {
                l.hierarchyInvalidated();
            }
            catch (Exception e) {
                SdkUtilActivator.logError("Error invoking hierarchy changed listener '" + l.getClass().getName() + "'.", e);
            }
            ++n2;
        }
    }

    @Override
    public void addHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_hierarchyListeners.add(ITypeHierarchyChangedListener.class, (EventListener)listener);
    }

    @Override
    public void removeHierarchyListener(ITypeHierarchyChangedListener listener) {
        this.m_hierarchyListeners.remove(ITypeHierarchyChangedListener.class, (EventListener)listener);
    }

    @Override
    public boolean isTypeAccepted(IType candidate, Set<IType> candidateSuperTypes) {
        return this.m_constraints.isTypeAccepted(candidate, candidateSuperTypes);
    }

    @Override
    public synchronized boolean isCreated() {
        return this.m_cachedTypes != null;
    }

    @Override
    public synchronized boolean contains(IType type) {
        if (type == null) {
            return false;
        }
        this.getTypesCached(null);
        return this.m_cachedTypes.contains(type);
    }

    @Override
    public synchronized void invalidate() {
        boolean wasCreated = this.isCreated();
        this.m_cachedTypes = null;
        if (wasCreated) {
            this.fireHierarchyChanged();
        }
    }

    @Override
    public IType getBaseType() {
        return this.m_baseType;
    }

    @Override
    public Set<IType> getAllTypes() {
        return this.getAllTypes(null);
    }

    @Override
    public Set<IType> getAllTypes(ITypeFilter filter) {
        return this.getAllTypes(filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IType> getAllTypes(ITypeFilter filter, Comparator<IType> comparator) {
        Set<IType> types = null;
        ProjectContextTypeHierarchyResult projectContextTypeHierarchyResult = this;
        synchronized (projectContextTypeHierarchyResult) {
            types = this.getTypesCached(null);
        }
        if (types == null) {
            return CollectionUtility.hashSet((Object[])new IType[0]);
        }
        AbstractSet result = null;
        result = comparator == null ? new HashSet(types.size()) : new TreeSet<IType>(comparator);
        if (filter == null) {
            for (IType candidate : types) {
                result.add((IType)candidate);
            }
        } else {
            for (IType candidate : types) {
                if (!filter.accept(candidate)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private Set<IType> getTypesCached(IProgressMonitor monitor) {
        if (this.m_cachedTypes == null) {
            try {
                final HashSet<IType> collector = new HashSet<IType>();
                SearchEngine e = new SearchEngine(JavaCore.getWorkingCopies(null));
                e.searchAllTypeNames(null, 0, null, 0, this.m_constraints.getSearchFor(), SearchEngine.createStrictHierarchyScope((IJavaProject)this.m_constraints.getClasspath(), (IType)this.getBaseType(), (boolean)true, (boolean)this.m_constraints.isIncludeBaseType(), null), new TypeNameMatchRequestor(){

                    public void acceptTypeNameMatch(TypeNameMatch match) {
                        if (ProjectContextTypeHierarchyResult.this.m_constraints.modifiersAccepted(match.getModifiers())) {
                            collector.add(match.getType());
                        }
                    }
                }, 3, monitor);
                this.m_cachedTypes = collector;
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("Unable to create type hierarchy for type " + this.m_constraints.getBaseType().getFullyQualifiedName(), e);
            }
        }
        return this.m_cachedTypes;
    }

    @Override
    public Iterator<IType> iterator() {
        return this.getAllTypes().iterator();
    }
}

