/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.signature.IResolvedTypeParameter;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.signature.internal.TypeParameterMapping;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class ResolvedTypeParameter
implements IResolvedTypeParameter {
    private final String m_typeParamName;
    private final Set<String> m_typeParamBounds;
    private final int m_ordinal;
    private final TypeParameterMapping m_owner;
    private final Map<String, Set<ResolvedTypeParameter>> m_superTypeParamReferences;
    private final Map<String, ResolvedTypeParameter> m_subTypeParamReferences;

    protected ResolvedTypeParameter(TypeParameterMapping owner, String signature, int ordinal) {
        this.m_ordinal = ordinal;
        this.m_owner = owner;
        this.m_typeParamName = "?";
        this.m_typeParamBounds = new LinkedHashSet<String>(1);
        this.m_typeParamBounds.add(signature);
        this.m_superTypeParamReferences = new LinkedHashMap<String, Set<ResolvedTypeParameter>>();
        this.m_subTypeParamReferences = new LinkedHashMap<String, ResolvedTypeParameter>();
    }

    protected ResolvedTypeParameter(TypeParameterMapping owner, TypeParameterMapping child, ITypeParameter param, Set<String> childParamBinds, Map<String, ResolvedTypeParameter> ownerParamBinds, int ordinal) throws JavaModelException {
        this.m_owner = owner;
        this.m_ordinal = ordinal;
        this.m_typeParamName = param.getElementName();
        LinkedHashSet<String> bounds = null;
        if (CollectionUtility.isEmpty(childParamBinds)) {
            Set<String> b = ResolvedTypeParameter.getTypeParamBounds(param);
            if (CollectionUtility.hasElements(b)) {
                bounds = new LinkedHashSet(b.size());
                for (String s : b) {
                    bounds.add(SignatureUtility.getResolvedSignature(owner.getType(), ownerParamBinds, s));
                }
            } else if (child == null) {
                bounds = new LinkedHashSet(1);
                String string = new StringBuilder(this.m_typeParamName.length() + 2).append('T').append(this.m_typeParamName).append(';').toString();
                bounds.add(string);
            } else {
                bounds = new LinkedHashSet(1);
                bounds.add(SignatureUtility.SIG_OBJECT);
            }
        } else {
            bounds = new LinkedHashSet<String>(childParamBinds);
        }
        this.m_typeParamBounds = bounds;
        this.m_superTypeParamReferences = new LinkedHashMap<String, Set<ResolvedTypeParameter>>();
        this.m_subTypeParamReferences = new LinkedHashMap<String, ResolvedTypeParameter>();
    }

    private static Set<String> getTypeParamBounds(ITypeParameter param) throws JavaModelException {
        String[] b = param.getBoundsSignatures();
        if (b.length > 0) {
            LinkedHashSet<String> bounds = new LinkedHashSet<String>(b.length);
            String[] stringArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                String bound = stringArray[n2];
                if (!SignatureUtility.SIG_OBJECT.equals(bound)) {
                    bounds.add(bound);
                }
                ++n2;
            }
            return bounds;
        }
        return null;
    }

    protected void addReference(ResolvedTypeParameter superParam) {
        String paramOwnerFqn = superParam.getOwnerMapping().getFullyQualifiedName();
        Set<ResolvedTypeParameter> set = this.m_superTypeParamReferences.get(paramOwnerFqn);
        if (set == null) {
            set = new LinkedHashSet<ResolvedTypeParameter>();
            this.m_superTypeParamReferences.put(paramOwnerFqn, set);
        }
        set.add(superParam);
        ResolvedTypeParameter old = superParam.m_subTypeParamReferences.put(this.getOwnerMapping().getFullyQualifiedName(), this);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate sub type param reference for owner type '" + this.getOwnerMapping().getFullyQualifiedName() + "' below '" + superParam.getOwnerMapping().getFullyQualifiedName() + "': Old: '" + old.toString() + "'. New: '" + this.toString() + "'.");
        }
    }

    @Override
    public Set<IResolvedTypeParameter> getSuperReferences(String ownerTypeFqn) {
        Set<ResolvedTypeParameter> c = this.m_superTypeParamReferences.get(ownerTypeFqn);
        if (c == null) {
            return new LinkedHashSet<IResolvedTypeParameter>(0);
        }
        return new LinkedHashSet<IResolvedTypeParameter>(c);
    }

    @Override
    public IResolvedTypeParameter getCorrespondingTypeParameterOnSubLevel(IType level) {
        if (!TypeUtility.exists((IJavaElement)level)) {
            return null;
        }
        return this.getCorrespondingTypeParameterOnSubLevel(level.getFullyQualifiedName());
    }

    @Override
    public IResolvedTypeParameter getCorrespondingTypeParameterOnSubLevel(String levelFullyQualifiedName) {
        if (StringUtility.isNullOrEmpty((CharSequence)levelFullyQualifiedName)) {
            return null;
        }
        return this.getCorrespondingTypeParameterOnSubLevelRec(this, levelFullyQualifiedName);
    }

    private ResolvedTypeParameter getCorrespondingTypeParameterOnSubLevelRec(ResolvedTypeParameter curParam, String levelFullyQualifiedName) {
        Map<String, ResolvedTypeParameter> curMap = curParam.m_subTypeParamReferences;
        ResolvedTypeParameter result = curMap.get(levelFullyQualifiedName);
        if (result != null) {
            return result;
        }
        for (ResolvedTypeParameter param : curMap.values()) {
            result = this.getCorrespondingTypeParameterOnSubLevelRec(param, levelFullyQualifiedName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public int getOrdinal() {
        return this.m_ordinal;
    }

    @Override
    public Map<String, Set<IResolvedTypeParameter>> getSuperReferences() {
        LinkedHashMap<String, Set<IResolvedTypeParameter>> result = new LinkedHashMap<String, Set<IResolvedTypeParameter>>(this.m_superTypeParamReferences.size());
        for (Map.Entry<String, Set<ResolvedTypeParameter>> entry : this.m_superTypeParamReferences.entrySet()) {
            result.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return result;
    }

    @Override
    public IResolvedTypeParameter getSubReference(String ownerTypeFqn) {
        return this.m_subTypeParamReferences.get(ownerTypeFqn);
    }

    @Override
    public Map<String, IResolvedTypeParameter> getSubReferences() {
        return new LinkedHashMap<String, IResolvedTypeParameter>(this.m_subTypeParamReferences);
    }

    @Override
    public String getTypeParameterName() {
        return this.m_typeParamName;
    }

    @Override
    public Set<String> getBoundsSignatures() {
        return new LinkedHashSet<String>(this.m_typeParamBounds);
    }

    @Override
    public TypeParameterMapping getOwnerMapping() {
        return this.m_owner;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_ordinal;
        result = 31 * result + (this.m_typeParamBounds == null ? 0 : this.m_typeParamBounds.hashCode());
        result = 31 * result + (this.m_typeParamName == null ? 0 : this.m_typeParamName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedTypeParameter)) {
            return false;
        }
        ResolvedTypeParameter other = (ResolvedTypeParameter)obj;
        if (this.m_ordinal != other.m_ordinal) {
            return false;
        }
        if (this.m_typeParamBounds == null ? other.m_typeParamBounds != null : !this.m_typeParamBounds.equals(other.m_typeParamBounds)) {
            return false;
        }
        return !(this.m_typeParamName == null ? other.m_typeParamName != null : !this.m_typeParamName.equals(other.m_typeParamName));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getTypeParameterName());
        Iterator<String> iterator = this.m_typeParamBounds.iterator();
        if (iterator.hasNext()) {
            sb.append(" extends ");
            sb.append(iterator.next());
            while (iterator.hasNext()) {
                sb.append(" & ");
                sb.append(iterator.next());
            }
        }
        return sb.toString();
    }
}

