/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.PhantomJarFilesDeleteWizard;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CleanupPhantomJarFileExecutor
extends AbstractExecutor {
    public boolean canRun(IStructuredSelection selection) {
        return this.isEditable(UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection));
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        IScoutBundle scoutBundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
        Set<IFile> phantomJarFiles = this.getPhantomJarFiles(scoutBundle);
        if (phantomJarFiles.isEmpty()) {
            MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 34);
            messageBox.setText(Texts.get("Information"));
            messageBox.setMessage(Texts.get("NoPhantomJarFilesFound"));
            messageBox.open();
            return null;
        }
        PhantomJarFilesDeleteWizard wizard = new PhantomJarFilesDeleteWizard(scoutBundle, phantomJarFiles);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setHelpAvailable(false);
        wizardDialog.open();
        return null;
    }

    private Set<IFile> getPhantomJarFiles(IScoutBundle bundle) {
        IFolder folder = JaxWsSdkUtility.getFolder(bundle, JaxWsConstants.STUB_FOLDER, false);
        if (folder == null || !folder.exists()) {
            return CollectionUtility.hashSet((Object[])new IFile[0]);
        }
        HashSet<IFile> usedJarFiles = new HashSet<IFile>();
        usedJarFiles.addAll(this.getProviderJarFiles(bundle));
        usedJarFiles.addAll(this.getConsumerJarFiles(bundle));
        HashSet<IFile> candidates = new HashSet<IFile>();
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource resource = iResourceArray[n2];
                if (resource.exists() && resource.getType() == 1 && "jar".equalsIgnoreCase((file = (IFile)resource).getFileExtension())) {
                    candidates.add(file);
                }
                ++n2;
            }
            HashSet<IFile> phantomJarFiles = new HashSet<IFile>();
            for (IFile candiate : candidates) {
                if (usedJarFiles.contains(candiate)) continue;
                phantomJarFiles.add(candiate);
            }
            return phantomJarFiles;
        }
        catch (CoreException e) {
            JaxWsSdk.logError(e);
            return CollectionUtility.hashSet((Object[])new IFile[0]);
        }
    }

    private Set<IFile> getProviderJarFiles(IScoutBundle bundle) {
        HashSet<IFile> jarFiles = new HashSet<IFile>();
        XmlResource sunJaxWsResource = ResourceFactory.getSunJaxWsResource(bundle);
        Document sunJaxWsXmlDocument = sunJaxWsResource.loadXml();
        if (sunJaxWsXmlDocument == null || sunJaxWsXmlDocument.getDocumentElement() == null) {
            return CollectionUtility.hashSet((Object[])new IFile[0]);
        }
        String tagName = StringUtility.join((String)":", (Object[])new Object[]{JaxWsSdkUtility.getXmlPrefix(sunJaxWsXmlDocument.getDocumentElement()), "endpoint"});
        List<Element> childElements = JaxWsSdkUtility.getChildElements(sunJaxWsXmlDocument.getDocumentElement().getChildNodes(), tagName);
        for (Element sunJaxWsXml : childElements) {
            IFile jarFile;
            SunJaxWsBean sunJaxWsBean = new SunJaxWsBean(sunJaxWsXml);
            BuildJaxWsBean buildJaxWsBean = BuildJaxWsBean.load(bundle, sunJaxWsBean.getAlias(), WebserviceEnum.PROVIDER);
            if (buildJaxWsBean == null || (jarFile = JaxWsSdkUtility.getStubJarFile(bundle, buildJaxWsBean, sunJaxWsBean.getWsdl())) == null || !jarFile.exists()) continue;
            jarFiles.add(jarFile);
        }
        return jarFiles;
    }

    private Set<IFile> getConsumerJarFiles(IScoutBundle bundle) {
        HashSet<IFile> jarFiles = new HashSet<IFile>();
        ICachedTypeHierarchy hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"));
        Set wsConsumerTypes = hierarchy.getAllSubtypes(TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"), ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)bundle));
        for (IType consumerType : wsConsumerTypes) {
            IFile jarFile;
            BuildJaxWsBean buildJaxWsBean;
            if (!TypeUtility.exists((IJavaElement)consumerType) || (buildJaxWsBean = BuildJaxWsBean.load(bundle, consumerType.getElementName(), WebserviceEnum.CONSUMER)) == null || (jarFile = JaxWsSdkUtility.getStubJarFile(bundle, buildJaxWsBean, buildJaxWsBean.getWsdl())) == null || !jarFile.exists()) continue;
            jarFiles.add(jarFile);
        }
        return jarFiles;
    }
}

