/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import java.util.Arrays;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.TypeSelectionDialog;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class MissingEndpointPropertyCommand
extends AbstractExecutableMarkerCommand {
    private IType m_implType;
    private IType m_annotationType;
    private String m_property;
    private IType m_portTypeInterfaceType;
    private IFile m_stubJarFile;
    private QName m_portTypeQName;

    public MissingEndpointPropertyCommand(IType implType) {
        super("Missing or invalid " + WebService.class.getSimpleName() + " annotation declaration");
        this.m_implType = implType;
        this.m_annotationType = TypeUtility.getType((String)WebService.class.getName());
        this.m_property = "endpointInterface";
        this.setSolutionDescription("By using this task, the annotation declaration is updated.");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        IType portTypeInterfaceType = null;
        if (this.m_portTypeQName != null) {
            portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(this.m_portTypeQName, this.m_stubJarFile);
        }
        IType[] candidates = portTypeInterfaceType != null ? new IType[]{portTypeInterfaceType} : JaxWsSdkUtility.resolvePortTypeInterfaceTypes(null, this.m_stubJarFile);
        TypeSelectionDialog dialog = new TypeSelectionDialog(ScoutSdkUi.getShell(), Texts.get("PortTypeInterface"), Texts.get("PleaseChoosePortTypeInterface"));
        dialog.setElements(Arrays.asList(candidates));
        if (dialog.open() == 0) {
            this.m_portTypeInterfaceType = (IType)dialog.getElement();
            return true;
        }
        return false;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        AnnotationUpdateOperation op = new AnnotationUpdateOperation();
        op.setDeclaringType(this.m_implType);
        op.setAnnotationType(this.m_annotationType);
        op.addStringProperty(this.m_property, this.m_portTypeInterfaceType.getFullyQualifiedName());
        new OperationJob(new IOperation[]{op}).schedule();
    }

    public IFile getStubJarFile() {
        return this.m_stubJarFile;
    }

    public void setStubJarFile(IFile stubJarFile) {
        this.m_stubJarFile = stubJarFile;
    }

    public QName getPortTypeQName() {
        return this.m_portTypeQName;
    }

    public void setPortTypeQName(QName portTypeQName) {
        this.m_portTypeQName = portTypeQName;
    }

    public IType getPortTypeInterfaceType() {
        return this.m_portTypeInterfaceType;
    }
}

