/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.JaxWsServletRegistrationOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.JaxWsServletRegistrationWizardPage;

public class JaxWsServletRegistrationWizard
extends AbstractWorkspaceWizard {
    private IScoutBundle m_bundle;
    private JaxWsServletRegistrationWizardPage m_wizardPage;
    private JaxWsServletRegistrationOperation m_operation;
    private SunJaxWsBean m_sunJaxWsBean;

    public JaxWsServletRegistrationWizard(IScoutBundle bundle) {
        this.m_bundle = bundle;
        this.m_operation = new JaxWsServletRegistrationOperation();
        this.setWindowTitle(Texts.get("JaxWsServletRegistration"));
    }

    public JaxWsServletRegistrationWizard(IScoutBundle bundle, SunJaxWsBean sunJaxWsBean) {
        this.m_bundle = bundle;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_operation = new JaxWsServletRegistrationOperation();
        this.m_operation.setSunJaxWsBean(this.m_sunJaxWsBean);
        this.setWindowTitle(Texts.get("JaxWsServletRegistration"));
    }

    public void addPages() {
        this.m_wizardPage = new JaxWsServletRegistrationWizardPage(this.m_bundle, this.m_sunJaxWsBean != null);
        this.m_wizardPage.setTitle(Texts.get("ChangeJaxWsServletRegistration"));
        if (this.m_sunJaxWsBean != null) {
            this.m_wizardPage.setUrlPattern(this.m_sunJaxWsBean.getUrlPattern());
            this.m_wizardPage.setTitle(Texts.get("SpecifyUrlOfWsdl"));
        } else {
            this.m_wizardPage.setTitle(Texts.get("ChangeJaxWsServletRegistration"));
        }
        this.m_wizardPage.initializeDefaultValues(this.m_bundle);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_operation.setBundle(this.m_bundle);
        this.m_operation.setRegistrationBundle(this.m_wizardPage.getRegistrationBundle());
        this.m_operation.setJaxWsAlias(this.m_wizardPage.getAlias());
        if (this.m_sunJaxWsBean != null) {
            this.m_operation.setSunJaxWsBean(this.m_sunJaxWsBean);
            this.m_operation.setUrlPattern(this.m_wizardPage.getUrlPattern());
        }
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        JaxWsSdk.getDefault().getMarkerQueueManager().suspend();
        try {
            this.m_operation.run(monitor, workingCopyManager);
        }
        finally {
            JaxWsSdk.getDefault().getMarkerQueueManager().resume();
        }
        return true;
    }
}

