/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.operation.service.ServiceRegistrationDescription;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.BindingFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.BuildJaxWsEntryCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.ExternalFileCopyOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsConsumerImplNewOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsStubGenerationOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsConsumerImplClassWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsPropertiesExistingWsdlWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsStubWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsdlLocationWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.GlobalBindingRegistrationHelper;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IOperationFinishedListener;

public class WsConsumerNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_SERVICE_IMPLEMENTATION = 100;
    public static final int TYPE_SERVICE_REG_SERVER = 101;
    private IScoutBundle m_bundle;
    private WsdlLocationWizardPage m_wsdlLocationWizardPage;
    private WsPropertiesExistingWsdlWizardPage m_wsPropertiesExistingWsdlWizardPage;
    private WsConsumerImplClassWizardPage m_wsConsumerImplClassWizardPage;
    private WsStubWizardPage m_wsStubWizardPage;
    private ExternalFileCopyOperation[] m_copyOperations;
    private BuildJaxWsEntryCreateOperation m_buildJaxWsEntryCreateOperation;
    private WsStubGenerationOperation m_stubGenerationOperation;
    private WsConsumerImplNewOperation m_wsConsumerImplNewOperation;
    private QName m_serviceQName;
    private QName m_portTypeQName;
    private String m_alias;
    private boolean m_createBindingFile;
    private String m_wsdlFileName;

    public WsConsumerNewWizard(IScoutBundle bundle) {
        this.m_bundle = bundle;
        this.m_copyOperations = new ExternalFileCopyOperation[0];
        this.setWindowTitle(Texts.get("CreateWsConsumer"));
    }

    public void addPages() {
        this.m_wsdlLocationWizardPage = new WsdlLocationWizardPage(this.m_bundle);
        this.m_wsdlLocationWizardPage.setTitle(Texts.get("CreateWsConsumer"));
        this.m_wsdlLocationWizardPage.setWsdlFolderVisible(true);
        this.m_wsdlLocationWizardPage.setWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_CONSUMER, false));
        this.m_wsdlLocationWizardPage.setRootWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_CONSUMER, false));
        this.m_wsdlLocationWizardPage.addPropertyChangeListener(new P_WsdlLocationPropertyListener());
        this.addPage((IWizardPage)this.m_wsdlLocationWizardPage);
        this.m_wsPropertiesExistingWsdlWizardPage = new WsPropertiesExistingWsdlWizardPage(this.m_bundle, WebserviceEnum.CONSUMER);
        this.m_wsPropertiesExistingWsdlWizardPage.setTitle(Texts.get("CreateWsConsumer"));
        this.m_wsPropertiesExistingWsdlWizardPage.addPropertyChangeListener(new P_WsPropertiesPropertyListener());
        this.addPage((IWizardPage)this.m_wsPropertiesExistingWsdlWizardPage);
        this.m_wsStubWizardPage = new WsStubWizardPage(this.m_bundle);
        this.m_wsStubWizardPage.setTitle(Texts.get("CreateWsConsumer"));
        this.addPage((IWizardPage)this.m_wsStubWizardPage);
        this.m_wsConsumerImplClassWizardPage = new WsConsumerImplClassWizardPage(this.m_bundle);
        this.m_wsConsumerImplClassWizardPage.setTitle(Texts.get("CreateWsConsumer"));
        this.addPage((IWizardPage)this.m_wsConsumerImplClassWizardPage);
    }

    protected boolean beforeFinish() throws CoreException {
        IFolder wsdlFolder = this.m_wsdlLocationWizardPage.getWsdlFolder();
        this.m_alias = this.m_wsConsumerImplClassWizardPage.getTypeName();
        File wsdlFile = this.m_wsdlLocationWizardPage.getWsdlFile();
        this.m_wsdlFileName = wsdlFile.getName();
        LinkedList<ExternalFileCopyOperation> copyOperations = new LinkedList<ExternalFileCopyOperation>();
        if (!JaxWsSdkUtility.existsFileInProject(this.m_bundle, wsdlFolder, wsdlFile)) {
            ExternalFileCopyOperation op = new ExternalFileCopyOperation();
            op.setBundle(this.m_bundle);
            op.setOverwrite(true);
            op.setExternalFile(this.m_wsdlLocationWizardPage.getWsdlFile());
            op.setWorkspacePath(wsdlFolder.getProjectRelativePath());
            copyOperations.add(op);
        }
        File[] fileArray = this.m_wsdlLocationWizardPage.getAdditionalFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!JaxWsSdkUtility.existsFileInProject(this.m_bundle, wsdlFolder, file)) {
                ExternalFileCopyOperation op = new ExternalFileCopyOperation();
                op.setBundle(this.m_bundle);
                op.setOverwrite(true);
                op.setExternalFile(file);
                op.setWorkspacePath(wsdlFolder.getProjectRelativePath());
                copyOperations.add(op);
            }
            ++n2;
        }
        this.m_copyOperations = copyOperations.toArray(new ExternalFileCopyOperation[copyOperations.size()]);
        this.m_buildJaxWsEntryCreateOperation = new BuildJaxWsEntryCreateOperation(WebserviceEnum.CONSUMER);
        this.m_buildJaxWsEntryCreateOperation.setBundle(this.m_bundle);
        this.m_buildJaxWsEntryCreateOperation.setAlias(this.m_alias);
        this.m_buildJaxWsEntryCreateOperation.setWsdlProjectRelativePath(wsdlFolder.getProjectRelativePath().append(wsdlFile.getName()));
        this.m_createBindingFile = this.m_wsStubWizardPage.isCreateBindingFile();
        Map<String, List<String>> buildProperties = JaxWsSdkUtility.getDefaultBuildProperties();
        Definition wsdlDefinition = this.m_wsdlLocationWizardPage.getWsdlDefinition();
        String defaultPackageName = JaxWsSdkUtility.resolveStubPackageName(null, wsdlDefinition);
        if (!CompareUtility.equals((Object)this.m_wsStubWizardPage.getPackageName(), (Object)defaultPackageName)) {
            JaxWsSdkUtility.addBuildProperty(buildProperties, "p", this.m_wsStubWizardPage.getPackageName());
        }
        this.m_buildJaxWsEntryCreateOperation.setBuildProperties(buildProperties);
        this.m_stubGenerationOperation = new WsStubGenerationOperation();
        this.m_stubGenerationOperation.setBundle(this.m_bundle);
        this.m_stubGenerationOperation.setAlias(this.m_alias);
        this.m_stubGenerationOperation.setWsdlFolder(wsdlFolder);
        this.m_stubGenerationOperation.setProperties(buildProperties);
        this.m_stubGenerationOperation.setWsdlFileName(wsdlFile.getName());
        this.m_stubGenerationOperation.addOperationFinishedListener(new P_StubGenerationFinishedListener());
        this.m_wsConsumerImplNewOperation = new WsConsumerImplNewOperation("I" + this.m_wsConsumerImplClassWizardPage.getTypeName(), this.m_wsConsumerImplClassWizardPage.getTypeName());
        this.m_wsConsumerImplNewOperation.setImplementationProject(this.m_bundle.getJavaProject());
        this.m_wsConsumerImplNewOperation.addServiceRegistration(new ServiceRegistrationDescription(this.m_bundle.getJavaProject()));
        this.m_wsConsumerImplNewOperation.setImplementationPackageName(this.m_wsConsumerImplClassWizardPage.getPackageName());
        this.m_wsConsumerImplNewOperation.setCreateScoutWebServiceAnnotation(this.m_wsConsumerImplClassWizardPage.isAnnotateImplClass());
        this.m_wsConsumerImplNewOperation.setAuthenticationHandlerQName(this.m_wsConsumerImplClassWizardPage.getAuthenticationHandler());
        this.m_portTypeQName = this.m_wsPropertiesExistingWsdlWizardPage.getPortType().getQName();
        if (this.m_wsPropertiesExistingWsdlWizardPage.getService() != null) {
            this.m_serviceQName = this.m_wsPropertiesExistingWsdlWizardPage.getService().getQName();
        }
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        JaxWsSdk.getDefault().getMarkerQueueManager().suspend();
        try {
            ExternalFileCopyOperation[] externalFileCopyOperationArray = this.m_copyOperations;
            int n = this.m_copyOperations.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalFileCopyOperation op = externalFileCopyOperationArray[n2];
                op.validate();
                op.run(monitor, workingCopyManager);
                ++n2;
            }
            if (this.m_createBindingFile) {
                Map<String, List<String>> buildProperties = this.m_buildJaxWsEntryCreateOperation.getBuildProperties();
                IFile wsdlFile = JaxWsSdkUtility.getFile(this.m_bundle, this.m_buildJaxWsEntryCreateOperation.getWsdlProjectRelativePath(), false);
                WsdlResource wsdlResource = new WsdlResource(this.m_bundle);
                wsdlResource.setFile(wsdlFile);
                GlobalBindingRegistrationHelper.SchemaCandidate[] schemaCandidates = GlobalBindingRegistrationHelper.getSchemaCandidates(wsdlResource.getFile());
                int i = 0;
                while (i < schemaCandidates.length) {
                    GlobalBindingRegistrationHelper.SchemaCandidate candidate = schemaCandidates[i];
                    String schemaTargetNamespace = null;
                    if (schemaCandidates.length > 1) {
                        schemaTargetNamespace = SchemaUtility.getSchemaTargetNamespace(candidate.getSchema());
                    }
                    IPath bindingFilePath = JaxWsSdkUtility.toUniqueProjectRelativeBindingFilePath(this.m_bundle, this.m_alias, schemaTargetNamespace);
                    BindingFileCreateOperation op = new BindingFileCreateOperation();
                    op.setBundle(this.m_bundle);
                    op.setWsdlDestinationFolder(this.m_wsdlLocationWizardPage.getWsdlFolder());
                    op.setSchemaTargetNamespace(schemaTargetNamespace);
                    if (candidate.getWsdlArtifact().getTypeEnum() == SchemaUtility.WsdlArtifact.TypeEnum.REFERENCED_WSDL) {
                        op.setWsdlLocation((IFile)candidate.getWsdlArtifact().getFileHandle().getFile());
                    }
                    op.setProjectRelativePath(bindingFilePath);
                    JaxWsSdkUtility.addBuildProperty(buildProperties, "b", bindingFilePath.toString());
                    if (i == 0) {
                        op.setCreateGlobalBindingSection(true);
                    }
                    op.validate();
                    op.run(monitor, workingCopyManager);
                    ++i;
                }
                this.m_buildJaxWsEntryCreateOperation.setBuildProperties(buildProperties);
            }
            this.m_stubGenerationOperation.validate();
            this.m_stubGenerationOperation.run(monitor, workingCopyManager);
            TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient")).invalidate();
            IFile stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsEntryCreateOperation.getBuildProperties(), this.m_wsdlFileName);
            IType portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(this.m_portTypeQName, stubJarFile);
            int maxWaitLoops = 10;
            while (portTypeInterfaceType == null && maxWaitLoops > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    JaxWsSdk.logError(e);
                }
                portTypeInterfaceType = JaxWsSdkUtility.resolvePortTypeInterfaceType(this.m_portTypeQName, stubJarFile);
                --maxWaitLoops;
            }
            IType serviceType = JaxWsSdkUtility.resolveServiceType(this.m_serviceQName, stubJarFile);
            this.m_wsConsumerImplNewOperation.setJaxWsPortType(portTypeInterfaceType);
            this.m_wsConsumerImplNewOperation.setJaxWsServiceType(serviceType);
            this.m_wsConsumerImplNewOperation.validate();
            this.m_wsConsumerImplNewOperation.run(monitor, workingCopyManager);
            String fqnWebserviceClient = this.m_wsConsumerImplNewOperation.getCreatedServiceImplementation().getFullyQualifiedName();
            maxWaitLoops = 10;
            while (!TypeUtility.exists((IJavaElement)TypeUtility.getType((String)fqnWebserviceClient)) && maxWaitLoops > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    JaxWsSdk.logError(e);
                }
                --maxWaitLoops;
            }
            this.m_buildJaxWsEntryCreateOperation.validate();
            this.m_buildJaxWsEntryCreateOperation.run(monitor, workingCopyManager);
            return true;
        }
        finally {
            JaxWsSdk.getDefault().getMarkerQueueManager().resume();
        }
    }

    private class P_StubGenerationFinishedListener
    implements IOperationFinishedListener {
        private P_StubGenerationFinishedListener() {
        }

        @Override
        public void operationFinished(boolean success, Throwable exception) {
        }
    }

    private class P_WsPropertiesPropertyListener
    implements PropertyChangeListener {
        private P_WsPropertiesPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("portType".equals(event.getPropertyName())) {
                String portTypeName = null;
                PortType portType = (PortType)event.getNewValue();
                if (portType != null) {
                    portTypeName = portType.getQName().getLocalPart();
                    WsConsumerNewWizard.this.m_wsConsumerImplClassWizardPage.setTypeName(JaxWsSdkUtility.getPlainPortTypeName(portTypeName));
                } else {
                    WsConsumerNewWizard.this.m_wsConsumerImplClassWizardPage.setTypeName(null);
                }
            }
        }
    }

    private class P_WsdlLocationPropertyListener
    implements PropertyChangeListener {
        private P_WsdlLocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("wsdlDefinition".equals(event.getPropertyName())) {
                Definition wsdlDefinition = (Definition)event.getNewValue();
                WsConsumerNewWizard.this.m_wsPropertiesExistingWsdlWizardPage.setWsdlDefinition(wsdlDefinition);
                if (wsdlDefinition != null) {
                    String defaultPackageName = JaxWsSdkUtility.resolveStubPackageName(null, wsdlDefinition);
                    WsConsumerNewWizard.this.m_wsStubWizardPage.setDefaultPackageName(defaultPackageName);
                    WsConsumerNewWizard.this.m_wsStubWizardPage.setPackageName(defaultPackageName);
                } else {
                    WsConsumerNewWizard.this.m_wsStubWizardPage.setDefaultPackageName(null);
                }
            }
        }
    }
}

