/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsdlFolderViewerFilter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WsdlSelectionWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_CREATE_NEW_WSDL = "createNewWsdl";
    public static final String PROP_WSDL_FOLDER = "wsdlFolder";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private Button m_newWsdlRadioButton;
    private Button m_existingWsdlRadioButton;
    private Label m_descriptionField;
    private TextField m_wsdlFolderField;
    private Button m_browseButton;
    private IFolder m_rootWsdlFolder;

    public WsdlSelectionWizardPage(IScoutBundle bundle) {
        super(WsdlSelectionWizardPage.class.getName());
        this.m_bundle = bundle;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.setDescription(Texts.get("ChooseWsdlFile"));
    }

    protected void createContent(Composite parent) {
        this.m_newWsdlRadioButton = new Button(parent, 16);
        this.m_newWsdlRadioButton.setText(Texts.get("CreateWsdlFromScratch"));
        this.m_newWsdlRadioButton.setSelection(this.isNewWsdl());
        this.m_newWsdlRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WsdlSelectionWizardPage.this.setStateChanging(true);
                    WsdlSelectionWizardPage.this.setNewWsdl(WsdlSelectionWizardPage.this.m_newWsdlRadioButton.getSelection());
                }
                finally {
                    WsdlSelectionWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_existingWsdlRadioButton = new Button(parent, 16);
        this.m_existingWsdlRadioButton.setText(Texts.get("UseExistingWsdlFile"));
        this.m_existingWsdlRadioButton.setSelection(!this.isNewWsdl());
        this.m_descriptionField = new Label(parent, 64);
        this.m_descriptionField.setText(Texts.get("ChooseFolderForWsdlFileAndArtefacts"));
        this.m_wsdlFolderField = new TextField(parent);
        this.m_wsdlFolderField.setLabelText(Texts.get("WsdlFolder"));
        this.m_wsdlFolderField.getTextComponent().setBackground(JaxWsSdkUtility.getColorLightGray());
        this.m_wsdlFolderField.setEditable(false);
        this.m_browseButton = new Button(parent, 0x800008);
        this.m_browseButton.setText(Texts.get("Browse"));
        this.m_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFolder folder = JaxWsSdkUtility.openProjectFolderDialog(WsdlSelectionWizardPage.this.m_bundle, new WsdlFolderViewerFilter(WsdlSelectionWizardPage.this.getRootWsdlFolder()), Texts.get("WsdlFolder"), Texts.get("ChooseFolderForWsdlFileAndArtefacts"), WsdlSelectionWizardPage.this.m_rootWsdlFolder, WsdlSelectionWizardPage.this.getWsdlFolder());
                if (folder != null) {
                    WsdlSelectionWizardPage.this.setWsdlFolder(folder);
                }
            }
        });
        IFolder folder = this.getWsdlFolder();
        if (folder != null) {
            this.m_wsdlFolderField.setText(folder.getProjectRelativePath().toString());
        }
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_newWsdlRadioButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_newWsdlRadioButton, 5, 1024);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_existingWsdlRadioButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_existingWsdlRadioButton, 20, 1024);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_descriptionField, 5, 1024);
        formData.left = new FormAttachment(-5, 0);
        formData.right = new FormAttachment(100, -75);
        this.m_wsdlFolderField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_wsdlFolderField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_browseButton.setLayoutData((Object)formData);
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (this.m_bundle == null) {
            return;
        }
        if (this.getWsdlFolder() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_wsdlFolderField.getText())));
        }
    }

    public void setNewWsdl(boolean newWsdl) {
        try {
            this.setStateChanging(true);
            this.setNewWsdlInternal(newWsdl);
            if (this.isControlCreated()) {
                this.m_newWsdlRadioButton.setSelection(newWsdl);
                this.m_existingWsdlRadioButton.setSelection(!newWsdl);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNewWsdlInternal(boolean newWsdl) {
        this.m_propertySupport.setProperty(PROP_CREATE_NEW_WSDL, (Object)newWsdl);
    }

    public boolean isNewWsdl() {
        return this.m_propertySupport.getPropertyBool(PROP_CREATE_NEW_WSDL);
    }

    public void setWsdlFolder(IFolder wsdlFolder) {
        try {
            this.setStateChanging(true);
            this.setWsdlFolderInternal(wsdlFolder);
            if (this.isControlCreated()) {
                if (wsdlFolder != null) {
                    this.m_wsdlFolderField.setText(wsdlFolder.getProjectRelativePath().toString());
                } else {
                    this.m_wsdlFolderField.setText("");
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setWsdlFolderInternal(IFolder wsdlFolder) {
        this.m_propertySupport.setProperty(PROP_WSDL_FOLDER, (Object)wsdlFolder);
    }

    public IFolder getWsdlFolder() {
        return (IFolder)this.m_propertySupport.getProperty(PROP_WSDL_FOLDER);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    public IFolder getRootWsdlFolder() {
        return this.m_rootWsdlFolder;
    }

    public void setRootWsdlFolder(IFolder rootWsdlFolder) {
        this.m_rootWsdlFolder = rootWsdlFolder;
    }
}

