/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.mail;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.RFCWrapperPart;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.mail.CharsetSafeMimeMessage;
import org.eclipse.scout.commons.mail.MailAttachment;
import org.eclipse.scout.commons.mail.MailMessage;

public class MailUtility {
    public static final String CONTENT_TYPE_ID = "Content-Type";
    public static final String CONTENT_TRANSFER_ENCODING_ID = "Content-Transfer-Encoding";
    public static final String QUOTED_PRINTABLE = "quoted-printable";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html; charset=\"UTF-8\"";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain; charset=\"UTF-8\"";
    public static final String CONTENT_TYPE_MESSAGE_RFC822 = "message/rfc822";
    public static final String CONTENT_TYPE_MULTIPART = "alternative";
    private static final String UTF_8 = "UTF-8";

    static {
        MailUtility.fixMailcapCommandMap();
    }

    private MailUtility() {
    }

    public static List<Part> getBodyParts(Part message) throws ProcessingException {
        ArrayList<Part> bodyCollector = new ArrayList<Part>();
        MailUtility.collectMailParts(message, bodyCollector, null, null);
        return bodyCollector;
    }

    public static List<Part> getAttachmentParts(Part message) throws ProcessingException {
        ArrayList<Part> attachmentCollector = new ArrayList<Part>();
        MailUtility.collectMailParts(message, null, attachmentCollector, null);
        return attachmentCollector;
    }

    public static void collectMailParts(Part part, List<Part> bodyCollector, List<Part> attachmentCollector, List<Part> inlineAttachmentCollector) throws ProcessingException {
        if (part == null) {
            return;
        }
        try {
            String disp = part.getDisposition();
            if (disp != null && disp.equalsIgnoreCase("attachment")) {
                if (attachmentCollector != null) {
                    attachmentCollector.add(part);
                }
            } else if (part.getContent() instanceof Multipart) {
                Multipart multiPart = (Multipart)part.getContent();
                int i = 0;
                while (i < multiPart.getCount()) {
                    MailUtility.collectMailParts((Part)multiPart.getBodyPart(i), bodyCollector, attachmentCollector, inlineAttachmentCollector);
                    ++i;
                }
            } else if (part.isMimeType(CONTENT_TYPE_TEXT_PLAIN)) {
                if (bodyCollector != null) {
                    bodyCollector.add(part);
                }
            } else if (part.isMimeType(CONTENT_TYPE_TEXT_HTML)) {
                if (bodyCollector != null) {
                    bodyCollector.add(part);
                }
            } else if (part.isMimeType(CONTENT_TYPE_MESSAGE_RFC822) && part.getContent() instanceof MimeMessage) {
                if (attachmentCollector != null) {
                    MimeMessage msg = (MimeMessage)part.getContent();
                    String filteredSubjectText = StringUtility.filterText(msg.getSubject(), "a-zA-Z0-9_-", "");
                    String fileName = String.valueOf(StringUtility.hasText(filteredSubjectText) ? filteredSubjectText : "originalMessage") + ".eml";
                    RFCWrapperPart wrapperPart = new RFCWrapperPart(part, fileName);
                    attachmentCollector.add(wrapperPart);
                }
            } else if (disp != null && disp.equals("inline") && inlineAttachmentCollector != null) {
                inlineAttachmentCollector.add(part);
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Unexpected: ", e);
        }
    }

    public static String getPlainText(Part part) throws ProcessingException {
        String text = null;
        try {
            MimePart mimePart;
            byte[] content;
            List<Part> bodyParts = MailUtility.getBodyParts(part);
            Part plainTextPart = MailUtility.getPlainTextPart(bodyParts);
            if (plainTextPart instanceof MimePart && (content = IOUtility.getContent((mimePart = (MimePart)plainTextPart).getInputStream())) != null) {
                try {
                    text = new String(content, MailUtility.getCharacterEncodingOfMimePart(mimePart));
                }
                catch (UnsupportedEncodingException e) {
                    text = new String(content);
                }
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Unexpected: ", e);
        }
        return text;
    }

    public static Part getHtmlPart(List<Part> bodyParts) throws ProcessingException {
        for (Part p : bodyParts) {
            try {
                if (p == null || !p.isMimeType(CONTENT_TYPE_TEXT_HTML)) continue;
                return p;
            }
            catch (Exception e) {
                throw new ProcessingException("Unexpected: ", e);
            }
        }
        return null;
    }

    public static Part getPlainTextPart(List<Part> bodyParts) throws ProcessingException {
        for (Part p : bodyParts) {
            try {
                if (p == null || !p.isMimeType(CONTENT_TYPE_TEXT_PLAIN)) continue;
                return p;
            }
            catch (Exception e) {
                throw new ProcessingException("Unexpected: ", e);
            }
        }
        return null;
    }

    public static DataSource createDataSource(File file) throws ProcessingException {
        try {
            int indexDot = file.getName().lastIndexOf(46);
            if (indexDot > 0) {
                String fileName = file.getName();
                String ext = fileName.substring(indexDot + 1);
                return MailUtility.createDataSource(new FileInputStream(file), fileName, ext);
            }
            return null;
        }
        catch (Exception e) {
            throw new ProcessingException("Unexpected: ", e);
        }
    }

    public static DataSource createDataSource(InputStream inStream, String fileName, String fileExtension) throws ProcessingException {
        try {
            String mimeType = MailUtility.getContentTypeForExtension(fileExtension);
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            ByteArrayDataSource item = new ByteArrayDataSource(inStream, mimeType);
            item.setName(fileName);
            return item;
        }
        catch (Exception e) {
            throw new ProcessingException("Unexpected: ", e);
        }
    }

    public static MimeMessage createMimeMessage(MailMessage mailMessage) throws ProcessingException {
        BodyPart bodyPart;
        MimeMultipart multiPart;
        CharsetSafeMimeMessage m;
        block11: {
            if (mailMessage == null) {
                throw new IllegalArgumentException("Mail message is missing");
            }
            m = new CharsetSafeMimeMessage();
            multiPart = new MimeMultipart();
            bodyPart = MailUtility.createBodyPart(mailMessage.getBodyPlainText(), mailMessage.getBodyHtml());
            if (bodyPart != null) break block11;
            return null;
        }
        try {
            multiPart.addBodyPart(bodyPart);
            for (MailAttachment attachment : mailMessage.getAttachments()) {
                MimeBodyPart part = new MimeBodyPart();
                DataHandler handler = new DataHandler(attachment.getDataSource());
                part.setDataHandler(handler);
                part.setFileName(attachment.getDataSource().getName());
                if (StringUtility.hasText(attachment.getContentId())) {
                    part.setContentID("<" + attachment.getContentId() + ">");
                }
                multiPart.addBodyPart((BodyPart)part);
            }
            m.setContent((Multipart)multiPart);
            if (StringUtility.hasText(mailMessage.getSender())) {
                InternetAddress addrSender = new InternetAddress(mailMessage.getSender());
                m.setFrom((Address)addrSender);
                m.setSender((Address)addrSender);
            }
            if (StringUtility.hasText(mailMessage.getSubject())) {
                m.setSubject(mailMessage.getSubject(), UTF_8);
            }
            if (!CollectionUtility.isEmpty(mailMessage.getToRecipients())) {
                m.setRecipients(Message.RecipientType.TO, (Address[])MailUtility.parseAddresses(mailMessage.getToRecipients()));
            }
            if (!CollectionUtility.isEmpty(mailMessage.getCcRecipients())) {
                m.setRecipients(Message.RecipientType.CC, (Address[])MailUtility.parseAddresses(mailMessage.getCcRecipients()));
            }
            if (!CollectionUtility.isEmpty(mailMessage.getBccRecipients())) {
                m.setRecipients(Message.RecipientType.BCC, (Address[])MailUtility.parseAddresses(mailMessage.getBccRecipients()));
            }
            return m;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to create MimeMessage.", e);
        }
    }

    private static BodyPart createBodyPart(String bodyTextPlain, String bodyTextHtml) throws MessagingException {
        if (!StringUtility.isNullOrEmpty(bodyTextPlain) && !StringUtility.isNullOrEmpty(bodyTextHtml)) {
            MimeBodyPart plainPart = MailUtility.createSingleBodyPart(bodyTextPlain, CONTENT_TYPE_TEXT_PLAIN);
            MimeBodyPart htmlPart = MailUtility.createSingleBodyPart(bodyTextHtml, CONTENT_TYPE_TEXT_HTML);
            MimeMultipart multiPart = new MimeMultipart(CONTENT_TYPE_MULTIPART);
            multiPart.addBodyPart((BodyPart)plainPart);
            multiPart.addBodyPart((BodyPart)htmlPart);
            MimeBodyPart multiBodyPart = new MimeBodyPart();
            multiBodyPart.setContent((Multipart)multiPart);
            return multiBodyPart;
        }
        if (!StringUtility.isNullOrEmpty(bodyTextPlain)) {
            return MailUtility.createSingleBodyPart(bodyTextPlain, CONTENT_TYPE_TEXT_PLAIN);
        }
        if (!StringUtility.isNullOrEmpty(bodyTextHtml)) {
            return MailUtility.createSingleBodyPart(bodyTextHtml, CONTENT_TYPE_TEXT_HTML);
        }
        return null;
    }

    private static MimeBodyPart createSingleBodyPart(String bodyText, String contentType) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setText(bodyText, UTF_8);
        part.addHeader(CONTENT_TYPE_ID, contentType);
        return part;
    }

    public static MimeMessage createMessageFromBytes(byte[] bytes) throws ProcessingException {
        return MailUtility.createMessageFromBytes(bytes, null);
    }

    public static MimeMessage createMessageFromBytes(byte[] bytes, Session session) throws ProcessingException {
        try {
            ByteArrayInputStream st = new ByteArrayInputStream(bytes);
            return new MimeMessage(session, (InputStream)st);
        }
        catch (Exception e) {
            throw new ProcessingException("Unexpected: ", e);
        }
    }

    public static void addAttachmentsToMimeMessage(MimeMessage msg, List<File> attachments) throws ProcessingException {
        if (CollectionUtility.isEmpty(attachments)) {
            return;
        }
        try {
            MimeBodyPart multiPartBody;
            Object messageContent = msg.getContent();
            Multipart multiPart = null;
            if (messageContent instanceof Multipart && StringUtility.contains(((Multipart)messageContent).getContentType(), "multipart/mixed")) {
                multiPart = (Multipart)messageContent;
            } else if (messageContent instanceof Multipart) {
                multiPartBody = new MimeBodyPart();
                multiPartBody.setContent((Multipart)messageContent);
                multiPart = new MimeMultipart();
                msg.setContent(multiPart);
                multiPart.addBodyPart((BodyPart)multiPartBody);
            } else if (messageContent instanceof String) {
                multiPartBody = new MimeBodyPart();
                String message = (String)messageContent;
                String contentTypeHeader = StringUtility.join(" ", msg.getHeader(CONTENT_TYPE_ID));
                if (StringUtility.contains(contentTypeHeader, "html")) {
                    multiPartBody.setContent((Object)message, CONTENT_TYPE_TEXT_HTML);
                    multiPartBody.setHeader(CONTENT_TYPE_ID, CONTENT_TYPE_TEXT_HTML);
                    multiPartBody.setHeader(CONTENT_TRANSFER_ENCODING_ID, QUOTED_PRINTABLE);
                } else {
                    multiPartBody.setText(message);
                }
                multiPart = new MimeMultipart();
                msg.setContent(multiPart);
                multiPart.addBodyPart((BodyPart)multiPartBody);
            } else {
                throw new ProcessingException("Unsupported mime message format. Unable to add attachments.");
            }
            for (File attachment : attachments) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(attachment);
                bodyPart.setDataHandler(new DataHandler((DataSource)source));
                bodyPart.setFileName(MimeUtility.encodeText((String)attachment.getName(), (String)UTF_8, null));
                multiPart.addBodyPart((BodyPart)bodyPart);
            }
            msg.saveChanges();
        }
        catch (MessagingException e) {
            throw new ProcessingException("Failed to add attachment to existing mime message", e);
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to add attachment to existing mime message", e);
        }
    }

    public static String getContentTypeForExtension(String ext) {
        String type;
        if (ext == null) {
            return null;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        if ((type = FileUtility.getContentTypeForExtension(ext = ext.toLowerCase())) == null) {
            type = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType("tmp." + ext);
        }
        return type;
    }

    private static InternetAddress[] parseAddresses(List<String> addresses) throws AddressException {
        if (CollectionUtility.isEmpty(addresses)) {
            return null;
        }
        ArrayList<InternetAddress> addrList = new ArrayList<InternetAddress>();
        for (String address : addresses) {
            addrList.add(new InternetAddress(address));
        }
        return addrList.toArray(new InternetAddress[addrList.size()]);
    }

    private static String getCharacterEncodingOfMimePart(MimePart part) throws MessagingException {
        Pattern pattern = Pattern.compile("charset=\".*\"", 10);
        Matcher matcher = pattern.matcher(part.getContentType());
        String characterEncoding = UTF_8;
        if (matcher.find()) {
            if (matcher.group(0).split("\"").length >= 2) {
                characterEncoding = matcher.group(0).split("\"")[1];
            }
        } else {
            String chartsetEquals = "charset=";
            if (part.getContentType().contains("charset=") && part.getContentType().split("charset=").length == 2) {
                characterEncoding = part.getContentType().split("charset=")[1];
            }
        }
        return characterEncoding;
    }

    private static void fixMailcapCommandMap() {
        try {
            Class<?> textPlainClass;
            String className = "com.sun.mail.handlers.text_plain";
            try {
                textPlainClass = Class.forName("com.sun.mail.handlers.text_plain");
            }
            catch (Throwable t) {
                return;
            }
            CommandMap cmap = MailcapCommandMap.getDefaultCommandMap();
            if (!(cmap instanceof MailcapCommandMap)) {
                return;
            }
            ((MailcapCommandMap)cmap).addMailcap("text/plain;;x-java-content-handler=" + textPlainClass.getName());
            Field f = MailcapCommandMap.class.getDeclaredField("DB");
            f.setAccessible(true);
            Object[] dbArray = (Object[])f.get(cmap);
            f = Class.forName("com.sun.activation.registries.MailcapFile").getDeclaredField("type_hash");
            f.setAccessible(true);
            Map db0 = (Map)f.get(dbArray[0]);
            Map typeMap = (Map)db0.get("text/plain");
            List handlerList = (List)typeMap.get("content-handler");
            handlerList.remove("com.sun.mail.handlers.text_plain");
            handlerList.add(0, "com.sun.mail.handlers.text_plain");
        }
        catch (Throwable t) {
            ScoutLogManager.getLogger(MailUtility.class).warn("Failed fixing MailcapComandMap string handling: " + t);
        }
    }
}

