/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.LRUCache;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.AbstractMemoryPolicy;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ForceGCJob;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

public class MediumMemoryPolicy
extends AbstractMemoryPolicy {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MediumMemoryPolicy.class);
    private boolean m_release = false;
    private final LRUCache<String, AbstractMemoryPolicy.SearchFormState> m_searchFormCache = new LRUCache(5, 0L);
    private final LRUCache<String, Map<String, byte[]>> m_tableColumnFilterManagerState = new LRUCache(5, 0L);

    @Override
    protected void loadSearchFormState(IForm f, String pageFormIdentifier) throws ProcessingException {
        AbstractMemoryPolicy.SearchFormState state = (AbstractMemoryPolicy.SearchFormState)this.m_searchFormCache.get((Object)pageFormIdentifier);
        if (state != null) {
            if (state.formContentXml != null) {
                f.setXML(state.formContentXml);
            }
            if (state.searchFilter != null) {
                f.setSearchFilter(state.searchFilter);
            }
        }
    }

    @Override
    protected void storeSearchFormState(IForm f, String pageFormIdentifier) throws ProcessingException {
        if (f.isEmpty()) {
            this.m_searchFormCache.remove((Object)pageFormIdentifier);
        } else {
            String xml = f.getXML("UTF-8");
            SearchFilter filter = f.getSearchFilter();
            this.m_searchFormCache.put((Object)pageFormIdentifier, (Object)new AbstractMemoryPolicy.SearchFormState(xml, filter));
        }
    }

    @Override
    protected void storeColumnFilterState(ITable t, String pageTableIdentifier) throws ProcessingException {
        ITableColumnFilterManager filterManager = t.getColumnFilterManager();
        if (filterManager == null || filterManager.getFilters() == null || filterManager.getFilters().isEmpty()) {
            this.m_tableColumnFilterManagerState.remove((Object)pageTableIdentifier);
            return;
        }
        HashMap<String, byte[]> state = (HashMap<String, byte[]>)this.m_tableColumnFilterManagerState.get((Object)pageTableIdentifier);
        if (state == null) {
            state = new HashMap<String, byte[]>();
            this.m_tableColumnFilterManagerState.put((Object)pageTableIdentifier, state);
        }
        for (ITableColumnFilter filter : filterManager.getFilters()) {
            IColumn col = filter.getColumn();
            if (col.getColumnId() == null) continue;
            byte[] data = filterManager.getSerializedFilter(col);
            if (data == null || data.length == 0) {
                state.remove(col.getColumnId());
                continue;
            }
            state.put(col.getColumnId(), data);
        }
    }

    @Override
    protected void loadColumnFilterState(ITable t, String pageTableIdentifier) throws ProcessingException {
        if (t == null || t.getColumnFilterManager() == null) {
            return;
        }
        Map state = (Map)this.m_tableColumnFilterManagerState.get((Object)pageTableIdentifier);
        if (state != null) {
            for (Map.Entry entry : state.entrySet()) {
                Object col = t.getColumnSet().getColumnById((String)entry.getKey());
                if (col == null) continue;
                t.getColumnFilterManager().setSerializedFilter((byte[])entry.getValue(), (IColumn)col);
            }
        }
    }

    @Override
    public void afterOutlineSelectionChanged(IDesktop desktop) {
        try {
            long memMax;
            long memTotal;
            long memUsed;
            final AtomicLong nodeCount = new AtomicLong();
            if (desktop.getOutline() != null && desktop.getOutline().getSelectedNode() != null) {
                final HashSet<IPage> preservationSet = new HashSet<IPage>();
                IPage p = (IPage)desktop.getOutline().getSelectedNode();
                while (p != null) {
                    preservationSet.add(p);
                    p = p.getParentPage();
                }
                ITreeVisitor v = new ITreeVisitor(){

                    @Override
                    public boolean visit(ITreeNode node) {
                        IPage page = (IPage)node;
                        if (!preservationSet.contains(page) && page.getParentPage() != null && page.isChildrenLoaded()) {
                            nodeCount.getAndAdd(page.getChildNodeCount());
                        }
                        return true;
                    }
                };
                for (IOutline outline : desktop.getAvailableOutlines()) {
                    outline.visitNode(outline.getRootNode(), v);
                }
            }
            if ((memUsed = (memTotal = Runtime.getRuntime().totalMemory()) - Runtime.getRuntime().freeMemory()) > (memMax = Runtime.getRuntime().maxMemory()) * 80L / 100L || nodeCount.get() > 10000L) {
                this.m_release = true;
            }
        }
        catch (Exception e) {
            LOG.error(null, (Throwable)e);
        }
    }

    @Override
    public void beforeTablePageLoadData(IPageWithTable<?> page) {
        if (this.m_release) {
            IDesktop desktop = ClientJob.getCurrentSession().getDesktop();
            for (IOutline o : desktop.getAvailableOutlines()) {
                if (o == desktop.getOutline()) continue;
                o.selectNode(null);
            }
            ClientJob.getCurrentSession().getDesktop().releaseUnusedPages();
            System.gc();
            Job[] jobArray = Job.getJobManager().find(ClientJob.class);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                Job j = jobArray[n2];
                if (j instanceof ForceGCJob) {
                    j.cancel();
                }
                ++n2;
            }
            new ForceGCJob().schedule();
            this.m_release = false;
        }
        if (page.getTable() != null && ((ITable)page.getTable()).getRowCount() > 1000) {
            ((ITable)page.getTable()).discardAllRows();
        }
    }

    @Override
    public String toString() {
        return "Medium";
    }
}

