/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.IActionExtension;
import org.eclipse.scout.rt.client.extension.ui.action.menu.IMenuExtension;
import org.eclipse.scout.rt.client.extension.ui.action.menu.MenuChains;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.ActivityMapMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.ValueFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.tree.AbstractActionNode;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;

public abstract class AbstractMenu
extends AbstractActionNode<IMenu>
implements IMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractMenu.class);
    private boolean m_singleSelectionAction;
    private boolean m_multiSelectionAction;
    private boolean m_emptySpaceAction;
    private boolean m_visibleProperty;
    private Object m_ownerValue;

    public AbstractMenu() {
        this(true);
    }

    public AbstractMenu(boolean callInitializer) {
        super(callInitializer);
    }

    @Order(value=55.0)
    @ConfigProperty(value="MENU_TYPE")
    protected Set<? extends IMenuType> getConfiguredMenuTypes() {
        return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TreeMenuType.SingleSelection, ValueFieldMenuType.NotNull, ActivityMapMenuType.Activity});
    }

    @Override
    public final void handleOwnerValueChanged(Object newValue) throws ProcessingException {
        if (!CompareUtility.equals((Object)this.m_ownerValue, (Object)newValue)) {
            this.m_ownerValue = newValue;
            this.interceptOwnerValueChanged(newValue);
        }
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execOwnerValueChanged(Object newOwnerValue) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execAboutToShow() throws ProcessingException {
    }

    @Override
    public final void aboutToShow() {
        try {
            this.aboutToShowInternal();
            this.interceptAboutToShow();
        }
        catch (Throwable t) {
            LOG.warn("Action " + this.getClass().getName(), t);
        }
    }

    protected void aboutToShowInternal() {
    }

    protected Collection<ITableRow> convertToTableRows(Collection<?> input) {
        if (input == null) {
            return null;
        }
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>(input.size());
        for (Object o : input) {
            if (!(o instanceof ITableRow)) continue;
            rows.add((ITableRow)o);
        }
        if (rows.size() == input.size()) {
            return rows;
        }
        return null;
    }

    protected Collection<ITreeNode> convertToTreeNodes(Collection<?> input) {
        if (input == null) {
            return null;
        }
        ArrayList<ITreeNode> rows = new ArrayList<ITreeNode>(input.size());
        for (Object o : input) {
            if (!(o instanceof ITreeNode)) continue;
            rows.add((ITreeNode)o);
        }
        if (rows.size() == input.size()) {
            return rows;
        }
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMenuTypes(this.getConfiguredMenuTypes());
    }

    @Override
    public void addChildActions(Collection<? extends IMenu> actionList) {
        super.addChildActions(actionList);
        if (CollectionUtility.hasElements(actionList)) {
            this.afterChildMenusAdd(actionList);
        }
    }

    @Override
    public void removeChildActions(Collection<? extends IMenu> actionList) {
        super.removeChildActions(actionList);
        if (CollectionUtility.hasElements(actionList)) {
            this.afterChildMenusRemove(actionList);
        }
    }

    protected void afterChildMenusAdd(Collection<? extends IMenu> newChildMenus) {
        if (CollectionUtility.hasElements(newChildMenus)) {
            final Object ownerValue = this.m_ownerValue;
            IActionVisitor visitor = new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(ownerValue);
                        }
                        catch (ProcessingException e) {
                            LOG.error("error during handle owner value changed.", (Throwable)e);
                        }
                    }
                    return 1;
                }
            };
            for (IMenu iMenu : newChildMenus) {
                iMenu.acceptVisitor(visitor);
            }
        }
    }

    protected void afterChildMenusRemove(Collection<? extends IMenu> childMenusToRemove) {
        if (CollectionUtility.hasElements(childMenusToRemove)) {
            IActionVisitor visitor = new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(null);
                        }
                        catch (ProcessingException e) {
                            LOG.error("error during handle owner value changed.", (Throwable)e);
                        }
                    }
                    return 1;
                }
            };
            for (IMenu iMenu : childMenusToRemove) {
                iMenu.acceptVisitor(visitor);
            }
        }
    }

    @Override
    public Set<IMenuType> getMenuTypes() {
        return CollectionUtility.hashSet((Collection)((Set)this.propertySupport.getProperty("propMenuTypes")));
    }

    public void setMenuTypes(Set<? extends IMenuType> menuTypes) {
        this.propertySupport.setProperty("propMenuTypes", (Object)CollectionUtility.hashSet(menuTypes));
    }

    protected final void interceptAboutToShow() throws ProcessingException {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        MenuChains.MenuAboutToShowChain chain = new MenuChains.MenuAboutToShowChain(extensions);
        chain.execAboutToShow();
    }

    protected final void interceptOwnerValueChanged(Object newOwnerValue) throws ProcessingException {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        MenuChains.MenuOwnerValueChangedChain chain = new MenuChains.MenuOwnerValueChangedChain(extensions);
        chain.execOwnerValueChanged(newOwnerValue);
    }

    @Override
    protected IMenuExtension<? extends AbstractMenu> createLocalExtension() {
        return new LocalMenuExtension<AbstractMenu>(this);
    }

    protected static class LocalMenuExtension<OWNER extends AbstractMenu>
    extends AbstractActionNode.LocalActionNodeExtension<IMenu, OWNER>
    implements IMenuExtension<OWNER> {
        public LocalMenuExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execAboutToShow(MenuChains.MenuAboutToShowChain chain) throws ProcessingException {
            ((AbstractMenu)this.getOwner()).execAboutToShow();
        }

        @Override
        public void execOwnerValueChanged(MenuChains.MenuOwnerValueChangedChain chain, Object newOwnerValue) throws ProcessingException {
            ((AbstractMenu)this.getOwner()).execOwnerValueChanged(newOwnerValue);
        }
    }
}

