/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.cache;

import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.server.commons.cache.IClientIdentificationService;

public class ClientIdentificationService
implements IClientIdentificationService {
    protected static final String SCOUT_CLIENT_ID_KEY = "scid";

    @Override
    public String getClientId(HttpServletRequest req, HttpServletResponse res) {
        String existingId = this.findExistingId(req);
        if (existingId != null) {
            return existingId;
        }
        String newClientId = this.createNewId();
        this.setClientId(req, res, newClientId);
        return newClientId;
    }

    private String findExistingId(HttpServletRequest req) {
        Object clientIdRequestAttribute;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (SCOUT_CLIENT_ID_KEY.equals(cookie.getName())) {
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        if ((clientIdRequestAttribute = req.getAttribute(SCOUT_CLIENT_ID_KEY)) instanceof String) {
            return (String)clientIdRequestAttribute;
        }
        return null;
    }

    private void setClientId(HttpServletRequest req, HttpServletResponse res, String newClientId) {
        req.setAttribute(SCOUT_CLIENT_ID_KEY, (Object)newClientId);
        res.addCookie(new Cookie(SCOUT_CLIENT_ID_KEY, newClientId));
    }

    protected String createNewId() {
        return UUID.randomUUID().toString();
    }
}

