/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.bookmark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.services.common.bookmark.AbstractBookmarkStorageService;
import org.eclipse.scout.rt.shared.security.PublishUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-1.0f)
public class FileSystemBookmarkStorageService
extends AbstractBookmarkStorageService
implements IBookmarkStorageService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FileSystemBookmarkStorageService.class);
    public static final String GLOBAL_FILE_NAME = "all_users";

    @Override
    public void publishBookmarkData(BookmarkFolder publishFolder, Map<String, Object> targetGroup) throws ProcessingException {
        Object userId2;
        if (!ACCESS.check((Permission)new PublishUserBookmarkPermission())) {
            throw new ProcessingException("Function denied", (Throwable)new SecurityException("Function denied"));
        }
        HashSet<Object> set = new HashSet<Object>();
        Collection userIdList = (Collection)targetGroup.get("userIdList");
        if (userIdList != null) {
            for (Object userId : userIdList) {
                set.add(userId);
            }
        }
        if ((userId2 = targetGroup.get("userId")) != null) {
            set.add(userId2);
        }
        for (Object e : set) {
            this.publishBookmarkDataToUser(publishFolder, e);
        }
    }

    @Override
    protected Object getCurrentUserId() {
        return ServerJob.getCurrentSession().getUserId();
    }

    @Override
    protected BookmarkFolder readUserFolder(Object userId) throws ProcessingException {
        return this.readBookmarkFolder(userId + ".ser");
    }

    @Override
    protected BookmarkFolder readGlobalFolder() throws ProcessingException {
        return this.readBookmarkFolder("all_users.ser");
    }

    @Override
    protected void writeUserFolder(BookmarkFolder folder, Object userId) throws ProcessingException {
        this.writeBookmarkFolder(folder, userId + ".ser", (Permission)new UpdateUserBookmarkPermission());
    }

    @Override
    protected void writeGlobalFolder(BookmarkFolder folder) throws ProcessingException {
        this.writeBookmarkFolder(folder, "all_users.ser", (Permission)new UpdateUserBookmarkPermission());
    }

    private BookmarkFolder readBookmarkFolder(String filename) throws ProcessingException {
        RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
        RemoteFile f = ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).getRemoteFile(spec);
        if (f.exists()) {
            try {
                byte[] bytes = f.extractData();
                return (BookmarkFolder)SerializationUtility.createObjectSerializer().deserialize(bytes, BookmarkFolder.class);
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
        }
        return null;
    }

    private void writeBookmarkFolder(BookmarkFolder folder, String filename, Permission permission) throws ProcessingException {
        try {
            if (ACCESS.check((Permission)permission)) {
                byte[] bytes = SerializationUtility.createObjectSerializer().serialize((Object)folder);
                RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
                spec.readData((InputStream)new ByteArrayInputStream(bytes));
                ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).putRemoteFile(spec);
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ProcessingException("", (Throwable)e);
        }
    }
}

