/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallFactoryService;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="bf3702b8-ee95-4c7b-870d-105b9d0deec2")
public class CodeLookupCall<CODE_ID>
extends LocalLookupCall<CODE_ID>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Class<? extends ICodeType<?, CODE_ID>> m_codeTypeClass;
    private ICodeLookupCallVisitor<CODE_ID> m_filter;
    private Comparator<ILookupRow<CODE_ID>> m_sortComparator;

    public static <T> CodeLookupCall<T> newInstanceByService(Class<? extends ICodeType<?, T>> codeTypeClass) {
        return ((ICodeLookupCallFactoryService)SERVICES.getService(ICodeLookupCallFactoryService.class)).newInstance(codeTypeClass);
    }

    public CodeLookupCall(Class<? extends ICodeType<?, CODE_ID>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
    }

    public Comparator<ILookupRow<CODE_ID>> getSortComparator() {
        return this.m_sortComparator;
    }

    public void setSortComparator(Comparator<ILookupRow<CODE_ID>> comp) {
        this.m_sortComparator = comp;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CodeLookupCall other = (CodeLookupCall)obj;
        if (this.m_codeTypeClass != other.m_codeTypeClass) {
            return false;
        }
        return this.m_filter == other.m_filter;
    }

    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public void setFilter(ICodeLookupCallVisitor<CODE_ID> filter) {
        this.m_filter = filter;
    }

    public ICodeLookupCallVisitor getFilter() {
        return this.m_filter;
    }

    protected List<ILookupRow<CODE_ID>> execCreateLookupRowsFromCodes(List<? extends ICode<CODE_ID>> codes) {
        ArrayList<ILookupRow<CODE_ID>> a = new ArrayList<ILookupRow<CODE_ID>>(codes.size());
        for (ICode<CODE_ID> c : codes) {
            a.add(this.execCreateLookupRowFromCode(c));
        }
        return a;
    }

    protected ILookupRow<CODE_ID> execCreateLookupRowFromCode(ICode<CODE_ID> c) {
        Object parentId = null;
        if (c.getParentCode() != null) {
            parentId = c.getParentCode().getId();
        }
        return new LookupRow<Object>(c.getId(), c.getText(), c.getIconId(), c.getTooltipText(), c.getBackgroundColor(), c.getForegroundColor(), c.getFont(), c.isEnabled(), parentId, c.isActive());
    }

    @Deprecated
    public static <T> List<ILookupRow<T>> createLookupRowArray(List<? extends ICode<T>> codes) {
        ArrayList<ILookupRow<T>> rows = new ArrayList<ILookupRow<T>>(codes.size());
        for (ICode<T> code : codes) {
            rows.add(CodeLookupCall.createLookupRow(code));
        }
        return rows;
    }

    protected <T> List<ILookupRow<T>> createCodeLookupRowList(List<? extends ICode<T>> codes) {
        ArrayList<ILookupRow<T>> rows = new ArrayList<ILookupRow<T>>(codes.size());
        for (ICode<T> code : codes) {
            rows.add(this.createCodeLookupRow(code));
        }
        return rows;
    }

    @Deprecated
    public static <T> ILookupRow<T> createLookupRow(ICode<T> c) {
        Object parentId = null;
        if (c.getParentCode() != null) {
            parentId = c.getParentCode().getId();
        }
        return new LookupRow<Object>(c.getId(), c.getText(), c.getIconId(), c.getTooltipText(), c.getBackgroundColor(), c.getForegroundColor(), c.getFont(), c.isEnabled(), parentId, c.isActive());
    }

    protected <T> ILookupRow<T> createCodeLookupRow(ICode<T> c) {
        Object parentId = null;
        if (c.getParentCode() != null) {
            parentId = c.getParentCode().getId();
        }
        return new LookupRow<Object>(c.getId(), c.getText(), c.getIconId(), c.getTooltipText(), c.getBackgroundColor(), c.getForegroundColor(), c.getFont(), c.isEnabled(), parentId, c.isActive());
    }

    @Deprecated
    public static Pattern getSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        if (!(s = s.toLowerCase()).endsWith("*")) {
            s = String.valueOf(s) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern((String)s), 32);
    }

    @Override
    protected Pattern createSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        if (!(s = s.toLowerCase()).endsWith("*")) {
            s = String.valueOf(s) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern((String)s), 32);
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByKey() throws ProcessingException {
        ArrayList<ICode<CODE_ID>> list = new ArrayList<ICode<CODE_ID>>(1);
        ICode<CODE_ID> c = this.resolveCodeByKey();
        if (c != null) {
            list.add(c);
        }
        return this.execCreateLookupRowsFromCodes(list);
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByText() throws ProcessingException {
        Comparator<ILookupRow<CODE_ID>> comparator;
        final Pattern pat = this.createSearchPattern(this.getText());
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(this){

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                ILookupRow row;
                if (m_filter != null && !m_filter.visit(this, code, treeLevel)) {
                    return true;
                }
                if ((this.getActive().isUndefined() || this.getActive().getBooleanValue().booleanValue() == code.isActive()) && (row = this.execCreateLookupRowFromCode(code)) != null && row.getText() != null && pat.matcher(row.getText().toLowerCase()).matches()) {
                    this.add(row);
                }
                return true;
            }
        };
        this.resolveCodes(v);
        List result = v.getLookupRows();
        if (result.size() > 1 && (comparator = this.getSortComparator()) != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByAll() throws ProcessingException {
        Comparator<ILookupRow<CODE_ID>> comparator;
        final Pattern pat = this.createSearchPattern(this.getAll());
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(this){

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                ILookupRow row;
                if (m_filter != null && !m_filter.visit(this, code, treeLevel)) {
                    return true;
                }
                if ((this.getActive().isUndefined() || this.getActive().getBooleanValue().booleanValue() == code.isActive()) && (row = this.execCreateLookupRowFromCode(code)) != null && row.getText() != null && pat.matcher(row.getText().toLowerCase()).matches()) {
                    this.add(row);
                }
                return true;
            }
        };
        this.resolveCodes(v);
        List result = v.getLookupRows();
        if (result.size() > 1 && (comparator = this.getSortComparator()) != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByRec() throws ProcessingException {
        Comparator<ILookupRow<CODE_ID>> comparator;
        Object recValue = this.getRec();
        if (recValue instanceof Number && ((Number)recValue).longValue() == 0L) {
            recValue = null;
        }
        final Object key = recValue;
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(this){

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                ILookupRow row;
                if (m_filter != null && !m_filter.visit(this, code, treeLevel)) {
                    return true;
                }
                ICode parentCode = code.getParentCode();
                if ((this.getActive().isUndefined() || this.getActive().getBooleanValue().booleanValue() == code.isActive()) && (parentCode == null && key == null || parentCode != null && parentCode.getId() != null && parentCode.getId().equals(key)) && (row = this.execCreateLookupRowFromCode(code)) != null) {
                    this.add(row);
                }
                return true;
            }
        };
        this.resolveCodes(v);
        List result = v.getLookupRows();
        if (result.size() > 1 && (comparator = this.getSortComparator()) != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    protected ICode<CODE_ID> resolveCodeByKey() throws ProcessingException {
        Object key = this.getKey();
        ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
        if (t == null) {
            return null;
        }
        return t.getCode(key);
    }

    protected void resolveCodes(ICodeVisitor<ICode<CODE_ID>> v) throws ProcessingException {
        ICodeType<?, CODE_ID> t = CODES.getCodeType(this.m_codeTypeClass);
        if (t != null) {
            t.visit(v, false);
        }
    }

    private abstract class AbstractLookupRowCollector
    implements ICodeVisitor<ICode<CODE_ID>> {
        private List<ILookupRow<CODE_ID>> m_list = new ArrayList();

        public void add(ILookupRow<CODE_ID> row) {
            this.m_list.add(row);
        }

        public List<ILookupRow<CODE_ID>> getLookupRows() {
            return this.m_list;
        }
    }
}

