/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract;

import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.spec.client.gen.extract.AbstractNamedTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.LinkableTypeExtractor;

public class SmartFieldTypeExtractor
extends AbstractNamedTextExtractor<ISmartField<?>> {
    protected LinkableTypeExtractor<ICodeType> m_codeTypeExtroactor = new LinkableTypeExtractor(ICodeType.class, true);
    protected LinkableTypeExtractor<ILookupCall<?>> m_linkableTypeExtractor = new LinkableTypeExtractor(ILookupCall.class, true);

    public SmartFieldTypeExtractor() {
        super(TEXTS.get((String)"org.eclipse.scout.rt.spec.type"));
    }

    @Override
    public String getText(ISmartField<?> smartfield) {
        StringBuilder text = new StringBuilder();
        Class codeTypeClass = this.getCodeTypeClass(smartfield);
        if (codeTypeClass != null) {
            text.append(TEXTS.get((String)"org.eclipse.scout.rt.spec.codetype")).append(": ");
            text.append(this.m_codeTypeExtroactor.getText(this.getCodeTypeClass(smartfield)));
        } else if (smartfield.getLookupCall() != null) {
            text.append(TEXTS.get((String)"org.eclipse.scout.rt.spec.lookupcall")).append(": ");
            text.append(this.m_linkableTypeExtractor.getText(smartfield.getLookupCall()));
        } else {
            text.append(TEXTS.get((String)"org.eclipse.scout.rt.spec.na"));
        }
        return text.toString();
    }

    protected Class getCodeTypeClass(ISmartField<?> smartfield) {
        ILookupCall lookupCall;
        Class codeTypeClass = smartfield.getCodeTypeClass();
        if (codeTypeClass == null && (lookupCall = smartfield.getLookupCall()) instanceof CodeLookupCall) {
            codeTypeClass = ((CodeLookupCall)lookupCall).getCodeTypeClass();
        }
        return codeTypeClass;
    }
}

