/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.ui.swing.BaseSwingApplication;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.RankedExtension;
import org.eclipse.scout.rt.ui.swing.extension.ISwingApplicationExtension;

public class ExtensibleSwingApplication
extends BaseSwingApplication {
    private static final String EXTENSION_POINT = "org.eclipse.scout.rt.ui.swing.appextensions";
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ExtensibleSwingApplication.class);
    protected List<ISwingApplicationExtension> m_extensions = new ArrayList<ISwingApplicationExtension>();
    protected ISwingApplicationExtension defaultExtension;

    public ExtensibleSwingApplication() {
        this.readExtensionPoint();
        this.initialize();
    }

    ExtensibleSwingApplication(List<ISwingApplicationExtension> extensions) {
        this.m_extensions = extensions;
    }

    private void readExtensionPoint() {
        ArrayList<RankedExtension> rankedExtensions = new ArrayList<RankedExtension>();
        HashSet extensionIdSet = new HashSet();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xp = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] iExtensionArray = xp.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    ISwingApplicationExtension swingAppExtension = (ISwingApplicationExtension)element.createExecutableExtension("class");
                    String extensionId = swingAppExtension.getExtensionId();
                    if (extensionIdSet.contains(extensionId)) {
                        LOG.error("Already registred a swing application extension with extensionId=" + extensionId + ". ExtensionId must be unique");
                    } else {
                        int ranking = 0;
                        String rankingString = element.getAttribute("ranking");
                        if (rankingString != null) {
                            ranking = Integer.parseInt(rankingString);
                        }
                        rankedExtensions.add(new RankedExtension(ranking, swingAppExtension));
                        LOG.debug("Added swing application extension " + swingAppExtension + " (ranking=" + ranking + ")");
                    }
                }
                catch (CoreException e) {
                    LOG.error("failed to create swing application extension instance. element=" + element, (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        if (rankedExtensions.isEmpty()) {
            throw new IllegalStateException("no swing application extension contributed! at least one extension is required");
        }
        Collections.sort(rankedExtensions);
        LOG.info("Registered " + rankedExtensions.size() + " swing application extensions:");
        this.setExtensionsToRun(rankedExtensions);
    }

    protected void setExtensionsToRun(List<RankedExtension> rankedExtensions) {
        for (RankedExtension re : rankedExtensions) {
            this.m_extensions.add(re.extension);
            LOG.info("- " + re.extension);
        }
        this.defaultExtension = this.m_extensions.get(0);
        LOG.info("Default swing application extension: " + this.defaultExtension);
    }

    @Override
    ISwingEnvironment getSwingEnvironment() {
        return this.defaultExtension.getEnvironment();
    }

    @Override
    void initializeSwing() {
        for (ISwingApplicationExtension ext : this.m_extensions) {
            ext.initializeSwing();
        }
    }

    @Override
    protected final Object startInSubject(IApplicationContext context) throws Exception {
        for (ISwingApplicationExtension ext : this.m_extensions) {
            Object exitCode = ext.execStartInSubject(context, this.getProgressMonitor());
            if (exitCode != null) {
                return exitCode;
            }
            if (this.isClientSessionValid(ext.getClientSession())) continue;
            return EXIT_OK;
        }
        context.applicationRunning();
        this.stopSplashScreen();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExtensibleSwingApplication.this.startGUI();
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Error starting GUI", (Throwable)e);
            System.exit(0);
        }
        return this.runWhileActive();
    }

    void startGUI() {
        for (ISwingApplicationExtension ext : this.m_extensions) {
            ext.getEnvironment().showGUI(ext.getClientSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int runWhileActive() throws InterruptedException {
        int exitCode = IApplication.EXIT_OK;
        while (true) {
            ISwingApplicationExtension activeExtension = null;
            for (ISwingApplicationExtension ext : this.m_extensions) {
                if (!ext.getClientSession().isActive()) continue;
                activeExtension = ext;
                break;
            }
            if (activeExtension == null) {
                return exitCode;
            }
            IClientSession clientSession = activeExtension.getClientSession();
            Object object = clientSession.getStateLock();
            synchronized (object) {
                if (clientSession.isActive()) {
                    clientSession.getStateLock().wait();
                    exitCode = clientSession.getExitCode();
                }
            }
        }
    }

    @Override
    public Object start(IApplicationContext context) throws Exception {
        for (ISwingApplicationExtension ext : this.m_extensions) {
            Object exitCode = ext.execStart(context, this.getProgressMonitor());
            if (exitCode == null) continue;
            return exitCode;
        }
        return super.start(context);
    }

    public void stop() {
        for (ISwingApplicationExtension ext : this.m_extensions) {
            ext.getClientSession().stopSession();
        }
    }
}

