/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.ui.swing.basic.IconUtility;

public class SwingIconLocator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingIconLocator.class);
    public static final Pattern IMAGE_WITH_STATE_PATTERN = Pattern.compile("(.*)(_active|_disabled|_mouse|_mouse_over|_open|_over|_pressed|_rollover|_selected)", 2);
    private final Object m_cacheLock = new Object();
    private final HashMap<String, Image> m_imagesByNameCache = new HashMap();
    private final IIconLocator m_iconLocator;

    public SwingIconLocator(IIconLocator iconLocator) {
        this.m_iconLocator = iconLocator;
    }

    public Icon getIcon(String name) {
        if (name == null || "null".equals(name)) {
            return null;
        }
        Image img = this.getImage(name);
        if (img != null) {
            return new ImageIcon(img, name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        Image img;
        if (name == null || "null".equals(name) || name.length() == 0) {
            return null;
        }
        Object object = this.m_cacheLock;
        synchronized (object) {
            img = this.m_imagesByNameCache.get(name);
            if (img == null && !this.m_imagesByNameCache.containsKey(name)) {
                img = this.createImageImpl(name);
                if (img == null) {
                    img = this.autoCreateMissingImage(name);
                }
                this.m_imagesByNameCache.put(name, img);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("load image '" + name + "' as " + img);
                }
                if (img == null) {
                    this.warnImageNotFound(name);
                }
            }
        }
        return img;
    }

    private Image createImageImpl(String name) {
        IconSpec iconSpec = this.m_iconLocator.getIconSpec(name);
        if (iconSpec != null) {
            Image img = Toolkit.getDefaultToolkit().createImage(iconSpec.getContent());
            if (img != null && Platform.inDevelopmentMode() && name != null && name.matches("^(window\\d+|tray)$")) {
                img = this.decorateForDevelopment(img);
            }
            return img;
        }
        return null;
    }

    protected Image autoCreateMissingImage(String name) {
        Matcher m = IMAGE_WITH_STATE_PATTERN.matcher(name);
        if (!m.matches()) {
            return null;
        }
        String state = m.group(2);
        if ("_disabled".equalsIgnoreCase(state)) {
            Icon normal = this.getIcon(m.group(1));
            if (normal == null) {
                return null;
            }
            ImageIcon ii = IconUtility.blendIcon(IconUtility.grayIcon(normal), 0.6f, 0xEEEEEE, 0.4f);
            return ii != null ? ii.getImage() : null;
        }
        return null;
    }

    protected void warnImageNotFound(String name) {
        if (name == null) {
            return;
        }
        if ("window".equalsIgnoreCase(name)) {
            return;
        }
        Matcher m = IMAGE_WITH_STATE_PATTERN.matcher(name);
        if (m.matches()) {
            return;
        }
        LOG.warn("could not find image '" + name + "'");
    }

    protected Image decorateForDevelopment(Image img) {
        if (img == null) {
            return img;
        }
        try {
            ImageIcon icon = new ImageIcon(img);
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            BufferedImage devImg = new BufferedImage(w, h, 2);
            Graphics g = devImg.getGraphics();
            icon.paintIcon(null, g, 0, 0);
            ColorConvertOp grayOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            grayOp.filter(devImg, devImg);
            g.dispose();
            return devImg;
        }
        catch (Throwable t) {
            return img;
        }
    }
}

