/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class TextTransferable
implements Transferable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TextTransferable.class);
    private Map<DataFlavor, Object> m_flavorMap = new HashMap<DataFlavor, Object>();

    public TextTransferable(String plainText, String htmlText) {
        this.registerIfUndefined(DataFlavor.stringFlavor, plainText);
        String charset = DataFlavor.getTextPlainUnicodeFlavor().getParameter("charset");
        if (charset == null) {
            charset = "unicode";
        }
        this.registerIfUndefined(this.createFlavor("text/plain;charset=" + charset + ";class=java.io.InputStream"), this.toInputStream(plainText, charset));
        if (StringUtility.hasText((CharSequence)htmlText)) {
            this.registerIfUndefined(this.createFlavor("text/html;charset=" + charset + ";class=java.io.InputStream"), this.toInputStream(htmlText, charset));
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.m_flavorMap.keySet().toArray(new DataFlavor[this.m_flavorMap.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.m_flavorMap.containsKey(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        Object result = this.m_flavorMap.get(flavor);
        if (result instanceof InputStream) {
            this.resetInputStreamToStartFromBeginning((InputStream)result);
        }
        return result;
    }

    private void resetInputStreamToStartFromBeginning(InputStream is) {
        if (is != null) {
            try {
                is.reset();
            }
            catch (IOException e) {
                LOG.error("failed to reset the InputStream", (Throwable)e);
            }
        }
    }

    private InputStream toInputStream(String value, String encoding) {
        byte[] content = StringUtility.emptyIfNull((Object)value).getBytes(Charset.forName(encoding));
        return new ByteArrayInputStream(content);
    }

    private void registerIfUndefined(DataFlavor flavor, Object value) {
        if (flavor == null || value == null || this.m_flavorMap.containsKey(flavor)) {
            return;
        }
        this.m_flavorMap.put(flavor, value);
    }

    private DataFlavor createFlavor(String mimeType) {
        try {
            return new DataFlavor(mimeType);
        }
        catch (Throwable e) {
            LOG.error("failed to create data flavor", e);
            return null;
        }
    }
}

