/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import org.eclipse.scout.commons.CompareUtility;

public class JClock
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final boolean m_h24Mode;
    private boolean m_am;
    private int m_time;
    private int m_higlightedMark = -1;
    private Integer m_temporaryTime;
    private static final int SOFT_REPAINT_ALPHA_DELTA = 8;
    private static final int SOFT_REPAINT_INTERVAL = 24;

    public JClock(boolean h24Mode) {
        this.m_h24Mode = h24Mode;
        Dimension d = new Dimension(180, 180);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.setForeground(new Color(6793422));
        this.setOpaque(false);
        this.setName("Synth.Clock");
    }

    public boolean isAM() {
        return this.m_am;
    }

    public void setAM(boolean am) {
        this.m_am = am;
    }

    public int getTime() {
        return this.m_time;
    }

    public void setTime(int time) {
        if (this.m_time == (time = time / 15 * 15)) {
            return;
        }
        this.m_time = time;
        this.repaint();
    }

    public Integer getTimeAt(Point p) {
        int w = this.getWidth();
        int h = this.getHeight();
        int x = p.x - w / 2;
        int y = p.y - h / 2;
        int minutes = (int)((Math.atan2(x, -y) + Math.PI * 2) * 12.0 * 60.0 / Math.PI / 2.0);
        minutes %= 720;
        if (!this.isAM()) {
            minutes += 720;
        }
        minutes = (minutes + 7) / 15 * 15;
        return minutes;
    }

    public void setTemporaryTime(Integer temporaryTime) {
        Integer n = temporaryTime = temporaryTime != null ? Integer.valueOf(temporaryTime / 15 * 15) : null;
        if (CompareUtility.equals((Object)this.m_temporaryTime, (Object)temporaryTime)) {
            return;
        }
        this.m_temporaryTime = temporaryTime;
        this.m_higlightedMark = -1;
        this.m_higlightedMark = this.m_temporaryTime != null ? this.m_temporaryTime % 720 / 15 : -1;
        this.repaint();
    }

    public Integer getTemporaryTime() {
        return this.m_temporaryTime;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D sub = (Graphics2D)g2d.create();
        this.paintMarks(sub, this.getForeground(), this.getForeground());
        sub.dispose();
        sub = (Graphics2D)g2d.create();
        this.paintLabels(sub, Color.black);
        sub.dispose();
        int t = this.getTime();
        sub = (Graphics2D)g2d.create();
        this.paintHands(sub, this.getForeground(), this.getForeground(), t);
        sub.dispose();
    }

    protected void paintMarks(Graphics2D g, Color col, Color highlightedCol) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.translate(w / 2, h / 2);
        int i = 0;
        while (i < 48) {
            if (i == this.m_higlightedMark) {
                this.paintHighlightedMark(g, w, h, i, highlightedCol);
            } else {
                this.paintMark(g, w, h, i, col);
            }
            g.rotate(0.1308996938995747);
            ++i;
        }
    }

    protected void paintMark(Graphics2D g, int w, int h, int i, Color col) {
        g.setColor(col);
        if (i % 4 == 0) {
            g.fillRect(0, -h / 2, 1, 5);
        } else {
            g.fillOval(-1, -h / 2 + 3, 2, 2);
        }
    }

    protected void paintHighlightedMark(Graphics2D g, int w, int h, int i, Color col) {
        g.setColor(col);
        if (i % 4 == 0) {
            g.fillRect(-3, -h / 2 - 2, 6, 9);
        } else {
            g.fillOval(-4, -h / 2 - 1, 8, 8);
        }
    }

    protected void paintLabels(Graphics2D g, Color col) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(col);
        g.setFont(Font.decode("Arial-BOLD-10"));
        FontMetrics fm = g.getFontMetrics();
        g.translate(w / 2, h / 2);
        double ex = 0.0;
        double ey = -h / 2 + 8 + fm.getAscent() / 2;
        double phi = 0.5235987755982988;
        int i = 0;
        while (i < 12) {
            String s = "" + (this.m_am || !this.m_h24Mode ? i : i + 12);
            int slen = fm.stringWidth(s);
            g.drawString(s, (int)ex - slen / 2, (int)ey + fm.getAscent() / 2 - 1);
            double tmp = ex * Math.cos(phi) - ey * Math.sin(phi);
            ey = ex * Math.sin(phi) + ey * Math.cos(phi);
            ex = tmp;
            ++i;
        }
    }

    protected void paintHands(Graphics2D g, Color hourCol, Color minuteCol, int t) {
        int descent;
        int ascent;
        int w = this.getWidth();
        int h = this.getHeight();
        g.translate(w / 2, h / 2);
        if (minuteCol != null) {
            g.setPaint(minuteCol);
            double beta = Math.PI * 2 * (double)t / 60.0;
            g.rotate(beta);
            ascent = 22;
            descent = 6;
            g.fillRect(-1, -h / 2 + ascent, 2, h / 2 - ascent + descent);
            g.rotate(-beta);
        }
        if (hourCol != null) {
            g.setPaint(hourCol);
            double alpha = Math.PI * 2 * (double)t / 60.0 / 12.0;
            g.rotate(alpha);
            ascent = 38;
            descent = 6;
            g.fillRect(-2, -h / 2 + ascent, 4, h / 2 - ascent + descent);
        }
    }
}

