/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;

public class TimeChooser {
    private final EventListenerList m_listenerList = new EventListenerList();
    private JPanelEx m_container;
    private JTableEx m_table;
    private DateFormat m_timeFormat = DateFormat.getTimeInstance(3);

    public TimeChooser() {
        this.m_table = new JTableEx();
        this.m_table.setAutoResizeMode(4);
        this.m_table.setTableHeader(null);
        this.m_table.setModel(new P_TableModel());
        this.m_table.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void setValue(Object value) {
                if (value != null) {
                    this.setText(TimeChooser.this.m_timeFormat.format((Date)value));
                } else {
                    this.setText("n/a");
                }
            }
        });
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1 && TimeChooser.this.m_table.getSelectedRow() >= 0) {
                    TimeChooser.this.fireChangedEvent();
                }
            }
        });
        JScrollPaneEx sp = new JScrollPaneEx(this.m_table);
        this.m_container = new JPanelEx(new SingleLayout());
        this.m_container.add(sp);
        this.m_container.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int row = TimeChooser.this.m_table.getSelectedRow();
                if (row >= 0) {
                    TimeChooser.this.m_table.scrollRectToVisible(TimeChooser.this.m_table.getCellRect(Math.min(TimeChooser.this.m_table.getRowCount() - 1, row + 6), 0, true));
                    TimeChooser.this.m_table.scrollRectToVisible(TimeChooser.this.m_table.getCellRect(Math.max(0, row - 6), 0, true));
                }
            }
        });
        this.m_container.setBackground(UIManager.getColor("Calendar.date.background"));
        this.m_container.setName("Synth.TimeChooser");
        this.setTime(new Date());
    }

    public void addChangeListener(ChangeListener listener) {
        this.m_listenerList.add(ChangeListener.class, (EventListener)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.m_listenerList.remove(ChangeListener.class, (EventListener)listener);
    }

    public JPanel getContainer() {
        return this.m_container;
    }

    public void doChanged() {
        this.fireChangedEvent();
    }

    private void fireChangedEvent() {
        EventListener[] a = this.m_listenerList.getListeners(ChangeListener.class);
        if (a != null && a.length > 0) {
            ChangeEvent e = new ChangeEvent(this);
            int i = 0;
            while (i < a.length) {
                ((ChangeListener)a[i]).stateChanged(e);
                ++i;
            }
        }
    }

    public Date getTime() {
        int row = this.m_table.getSelectedRow();
        return (Date)(row >= 0 ? this.m_table.getValueAt(row, 0) : null);
    }

    public void setTime(Date value) {
        if (value == null) {
            value = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        int row = (cal.get(11) * 60 + cal.get(12)) / 30;
        this.m_table.setRowSelectionInterval(row, row);
    }

    public Double getTimeAsDouble() {
        Date t = this.getTime();
        if (t == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getTime());
        return 1.0 * (double)(cal.get(11) * 60 + cal.get(12)) / 1440.0;
    }

    public void setTimeAsAsDouble(Double d) {
        if (d == null) {
            this.setTime(null);
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.add(12, (int)(d * 24.0 * 60.0 + 0.5));
        this.setTime(cal.getTime());
    }

    protected Object[][] createTableData() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        Object[][] data = new Object[48][1];
        int i = 0;
        while (i < data.length) {
            data[i][0] = cal.getTime();
            cal.add(12, 30);
            ++i;
        }
        return data;
    }

    private class P_TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private Object[][] m_data;

        public P_TableModel() {
            this.m_data = TimeChooser.this.createTableData();
        }

        @Override
        public int getRowCount() {
            return this.m_data.length;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Date.class;
        }

        @Override
        public String getColumnName(int column) {
            return "Time";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.m_data[rowIndex][columnIndex];
        }
    }
}

