/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.labelfield;

import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.SizeRequirements;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.Highlighter;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ParagraphView;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextPaneEx;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.labelfield.ISwingScoutLabelField;
import org.eclipse.scout.rt.ui.swing.text.HTMLStyledTextCreator;
import org.eclipse.scout.rt.ui.swing.text.IStyledTextCreator;

public class SwingScoutLabelField
extends SwingScoutValueFieldComposite<ILabelField>
implements ISwingScoutLabelField {
    private static final long serialVersionUID = 1L;
    private JPanelEx m_fieldPanel;
    private int m_horizontalAlignment;
    private int m_verticalAlignment;
    private String m_unformattedText;
    private boolean m_textWrap;
    private IStyledTextCreator m_styledTextCreator;
    private Color m_foregroundColor;
    private Color m_backgroundColor;
    private TransferHandler m_transferHandler;
    private Highlighter m_highlighter;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        this.m_fieldPanel = new JPanelEx(new SingleLayout());
        LogicalGridData fieldData = LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((ILabelField)this.getScoutObject()).getGridData());
        fieldData.topInset = SwingLayoutUtility.getTextFieldTopInset();
        this.m_fieldPanel.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, fieldData);
        JTextPaneEx labelField = this.createLabelField();
        this.m_transferHandler = labelField.getTransferHandler();
        this.m_highlighter = labelField.getHighlighter();
        labelField.addComponentListener(new P_ResizeListener());
        this.m_fieldPanel.add(labelField);
        this.setTopMarginForField();
        this.m_styledTextCreator = this.createStyledTextCreator();
        container.add(this.m_fieldPanel);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(labelField);
        LogicalGridLayout layout = new LogicalGridLayout(this.getSwingEnvironment(), 1, 0);
        this.getSwingContainer().setLayout(layout);
    }

    protected JTextPaneEx createLabelField() {
        JTextPaneEx labelField = new JTextPaneEx();
        labelField.setContentType("text/html");
        HTMLEditorKit editorKit = this.createEditorKit();
        labelField.setEditorKit(editorKit);
        labelField.setBorder(null);
        return labelField;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.getSwingLabelField().setEditable(false);
        this.getSwingLabelField().setEnabled(b);
        this.updateTextInGUI();
    }

    protected HTMLEditorKit createEditorKit() {
        return new HTMLEditorKit(){
            private static final long serialVersionUID = 1L;

            @Override
            public ViewFactory getViewFactory() {
                return new HTMLEditorKit.HTMLFactory(){

                    @Override
                    public View create(Element element) {
                        View v = super.create(element);
                        if (v instanceof InlineView) {
                            Object o = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                            if (o instanceof HTML.Tag && o == HTML.Tag.BR) {
                                return v;
                            }
                            return new InlineView(element){

                                @Override
                                public int getBreakWeight(int axis, float pos, float len) {
                                    if (!SwingScoutLabelField.this.m_textWrap) {
                                        return super.getBreakWeight(axis, pos, len);
                                    }
                                    if (axis == 0) {
                                        this.checkPainter();
                                        int offset = this.getStartOffset();
                                        int maxPos = this.getGlyphPainter().getBoundedPosition(this, offset, pos, len);
                                        if (maxPos == offset) {
                                            return 0;
                                        }
                                        try {
                                            int separatorIndex = this.getDocument().getText(offset, maxPos - offset).indexOf(System.getProperty("line.separator"));
                                            if (separatorIndex >= 0) {
                                                return 3000;
                                            }
                                        }
                                        catch (BadLocationException badLocationException) {
                                            // empty catch block
                                        }
                                    }
                                    return super.getBreakWeight(axis, pos, len);
                                }

                                @Override
                                public View breakView(int axis, int offset, float pos, float len) {
                                    if (!SwingScoutLabelField.this.m_textWrap) {
                                        return super.breakView(axis, offset, pos, len);
                                    }
                                    if (axis == 0) {
                                        this.checkPainter();
                                        int maxPos = this.getGlyphPainter().getBoundedPosition(this, offset, pos, len);
                                        try {
                                            int separatorIndex = this.getDocument().getText(offset, maxPos - offset).indexOf(System.getProperty("line.separator"));
                                            if (separatorIndex >= 0) {
                                                GlyphView glyphView = (GlyphView)this.createFragment(offset, offset + separatorIndex + 1);
                                                return glyphView;
                                            }
                                        }
                                        catch (BadLocationException badLocationException) {
                                            // empty catch block
                                        }
                                    }
                                    return super.breakView(axis, offset, pos, len);
                                }
                            };
                        }
                        if (v instanceof ParagraphView) {
                            return new ParagraphView(element){

                                @Override
                                protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                                    if (!SwingScoutLabelField.this.m_textWrap) {
                                        return super.calculateMinorAxisRequirements(axis, r);
                                    }
                                    if (r == null) {
                                        r = new SizeRequirements();
                                    }
                                    float pref = this.layoutPool.getPreferredSpan(axis);
                                    float min = this.layoutPool.getMinimumSpan(axis);
                                    r.minimum = (int)min;
                                    r.preferred = Math.max(r.minimum, (int)pref);
                                    r.maximum = Integer.MAX_VALUE;
                                    r.alignment = 0.5f;
                                    return r;
                                }
                            };
                        }
                        return v;
                    }
                };
            }
        };
    }

    protected IStyledTextCreator createStyledTextCreator() {
        return new HTMLStyledTextCreator();
    }

    public IStyledTextCreator getStyledTextCreator() {
        return this.m_styledTextCreator;
    }

    protected void setTopMarginForField() {
        int topMargin = SwingUtility.getTopMarginForField();
        if (topMargin > 0) {
            this.m_fieldPanel.setBorder(new EmptyBorder(topMargin, 0, 0, 0));
        }
    }

    @Override
    public JTextPaneEx getSwingLabelField() {
        return (JTextPaneEx)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        ILabelField f = (ILabelField)this.getScoutObject();
        this.setTextWrapFromScout(f.isWrapText());
        this.setSelectableFromScout(f.isSelectable());
    }

    protected void setTextWrapFromScout(boolean b) {
        this.m_textWrap = b;
        this.updateTextInGUI();
    }

    protected void setSelectableFromScout(boolean b) {
        if (b) {
            this.getSwingLabelField().setHighlighter(this.m_highlighter);
            this.getSwingLabelField().setTransferHandler(this.m_transferHandler);
        } else {
            this.getSwingLabelField().setHighlighter(null);
            this.getSwingLabelField().setTransferHandler(null);
        }
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        this.m_unformattedText = s;
        this.updateTextInGUI();
    }

    public String getUnformattedText() {
        return this.m_unformattedText;
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        this.m_horizontalAlignment = SwingUtility.createHorizontalAlignment(scoutAlign);
        this.updateTextInGUI();
    }

    @Override
    protected void setVerticalAlignmentFromScout(int scoutAlign) {
        this.m_verticalAlignment = SwingUtility.createVerticalAlignment(scoutAlign);
        this.updateTextInGUI();
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("wrapText".equals(name)) {
            this.setTextWrapFromScout(((ILabelField)this.getScoutObject()).isWrapText());
        } else if ("selectable".equals(name)) {
            this.setSelectableFromScout(((ILabelField)this.getScoutObject()).isSelectable());
        }
    }

    protected String createStyledText() {
        Color bgColor = (Color)(this.m_backgroundColor != null ? this.m_backgroundColor : UIManager.getLookAndFeelDefaults().get("TextPane.background"));
        Color fgColor = ((ILabelField)this.getScoutObject()).isEnabled() ? this.m_foregroundColor : this.getSwingLabelField().getDisabledTextColor();
        this.getStyledTextCreator().setText(this.getUnformattedText()).setTextWrap(this.m_textWrap).setForegroundColor(fgColor).setBackgroundColor(bgColor).setHorizontalAlignment(this.m_horizontalAlignment).setVerticalAlignment(this.m_verticalAlignment).setHeight(this.adjustHeight(this.getSwingLabelField().getHeight()));
        return this.getStyledTextCreator().createStyledText();
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
        super.setBackgroundFromScout(scoutColor);
        this.m_backgroundColor = ColorUtility.createColor(scoutColor);
        this.updateTextInGUI();
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        super.setForegroundFromScout(scoutColor);
        this.m_foregroundColor = ColorUtility.createColor(scoutColor);
        this.updateTextInGUI();
    }

    protected void updateTextInGUI() {
        String styledText = this.createStyledText();
        if (this.hasTextChanged(styledText)) {
            this.getSwingLabelField().setText(styledText);
        }
    }

    private boolean hasTextChanged(String newText) {
        String oldText = this.getSwingLabelField().getText();
        return !StringUtility.nvl((Object)oldText, (String)"").equals(StringUtility.nvl((Object)newText, (String)""));
    }

    protected int adjustHeight(int height) {
        double factor = 0.0;
        if (height < 10) {
            factor = 0.0;
        } else if (height >= 10 && height < 150) {
            factor = 0.25;
        } else if (height >= 150 && height < 250) {
            factor = 0.24;
        } else if (height >= 250 && height < 400) {
            factor = 0.235;
        } else if (height >= 400 && height < 700) {
            factor = 0.2347;
        } else if (height >= 700 && height < 1000) {
            factor = 0.2335;
        } else if (height >= 1000) {
            factor = 0.233;
        }
        return (int)((double)height - (double)height * factor);
    }

    private class P_ResizeListener
    extends ComponentAdapter {
        int m_oldHeight = 0;

        private P_ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (this.m_oldHeight == e.getComponent().getHeight()) {
                return;
            }
            this.m_oldHeight = e.getComponent().getHeight();
            SwingScoutLabelField.this.updateTextInGUI();
        }
    }
}

