/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.textfield;

import javax.swing.JScrollPane;
import org.eclipse.scout.rt.client.services.common.spellchecker.ISpellingMonitor;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextAreaEx;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.ISwingScoutTextArea;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.SwingScoutTextFieldComposite;
import org.eclipse.scout.rt.ui.swing.spellchecker.ISwingSpellCheckerService;
import org.eclipse.scout.rt.ui.swing.spellchecker.SwingFieldHolder;
import org.eclipse.scout.service.SERVICES;

public class SwingScoutTextArea
extends SwingScoutTextFieldComposite<IStringField>
implements ISwingScoutTextArea {
    private JScrollPane m_swingScrollPane;
    private ISpellingMonitor m_spellingMonitor;

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        JPanelEx container = new JPanelEx();
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextAreaEx textField = new JTextAreaEx();
        textField.setOpaque(true);
        this.m_swingScrollPane = new JScrollPaneEx(textField);
        this.m_swingScrollPane.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((IStringField)this.getScoutObject()).getGridData()));
        container.add(this.m_swingScrollPane);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JScrollPane getSwingScrollPane() {
        return this.m_swingScrollPane;
    }

    @Override
    public JTextAreaEx getSwingTextArea() {
        return (JTextAreaEx)this.getSwingTextComponent();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setTextWrapFromScout(((IStringField)this.getScoutObject()).isWrapText());
        ISwingSpellCheckerService spellCheckerService = (ISwingSpellCheckerService)SERVICES.getService(ISwingSpellCheckerService.class);
        if (spellCheckerService != null && spellCheckerService.isInstalled()) {
            this.m_spellingMonitor = spellCheckerService.createSpellingMonitor(new SwingFieldHolder(this, this.getSwingTextArea()));
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_spellingMonitor != null) {
            this.m_spellingMonitor.dispose();
            this.m_spellingMonitor = null;
        }
        super.detachScout();
    }

    @Override
    protected void setKeyStrokesFromScout() {
        super.setKeyStrokesFromScout();
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        float swingAlignX = SwingUtility.createAlignmentX(scoutAlign);
        this.getSwingTextArea().setAlignmentX(swingAlignX);
    }

    @Override
    protected void setVerticalAlignmentFromScout(int scoutAlign) {
        float swingAlignY = SwingUtility.createAlignmentY(scoutAlign);
        this.getSwingTextArea().setAlignmentY(swingAlignY);
    }

    protected void setTextWrapFromScout(boolean b) {
        this.getSwingTextArea().setLineWrap(b);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("wrapText")) {
            this.setTextWrapFromScout((Boolean)newValue);
        }
    }
}

