/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.util.listener.WindowListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractSwtStartup
implements IStartup {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSwtStartup.class);

    protected abstract ISwtEnvironment getSwtEnvironment();

    public void earlyStartup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec((Runnable)new P_HandleInitWorkbench());
    }

    protected String getInitWorkbenchTaskText() {
        return SwtUtility.getNlsText(Display.getCurrent(), "ScoutStarting", new String[0]);
    }

    private synchronized void handlePerspectiveOpened() {
        P_InitWorkbenchJob j = new P_InitWorkbenchJob(this.getInitWorkbenchTaskText());
        j.schedule(10L);
    }

    private class P_HandleInitWorkbench
    implements Runnable {
        private P_HandleInitWorkbench() {
        }

        @Override
        public void run() {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null) {
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage == null || activePage.getPerspective() == null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new P_PerspectiveListener());
                } else {
                    AbstractSwtStartup.this.handlePerspectiveOpened();
                }
            } else {
                PlatformUI.getWorkbench().addWindowListener((IWindowListener)new WindowListener(){

                    @Override
                    public void windowActivated(IWorkbenchWindow window) {
                        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
                        if (window.getActivePage() == null || window.getActivePage().getPerspective() == null) {
                            window.addPerspectiveListener((IPerspectiveListener)new P_PerspectiveListener());
                        } else {
                            AbstractSwtStartup.this.handlePerspectiveOpened();
                        }
                    }
                });
            }
        }
    }

    private final class P_InitWorkbenchJob
    extends UIJob {
        public P_InitWorkbenchJob(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            monitor.beginTask(AbstractSwtStartup.this.getInitWorkbenchTaskText(), -1);
            AbstractSwtStartup.this.getSwtEnvironment().ensureInitialized();
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    private class P_PerspectiveListener
    extends PerspectiveAdapter {
        private P_PerspectiveListener() {
        }

        public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            page.getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
            AbstractSwtStartup.this.handlePerspectiveOpened();
        }
    }
}

