/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.ui.dialog.RenameDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty.BeanPropertyNodePage;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractRenameExecutor
extends AbstractExecutor {
    private RenameDialog m_dialog;
    private String m_oldName;
    private String m_readOnlySuffix;

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        this.m_dialog = new RenameDialog(shell, this.m_oldName, this.getReadOnlySuffix());
        this.m_dialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("newName".equals(evt.getPropertyName())) {
                    AbstractRenameExecutor.this.validateInternal((String)evt.getNewValue());
                }
            }
        });
        this.m_dialog.create();
        this.validateInternal(this.m_dialog.getNewName());
        if (this.m_dialog.open() == 0) {
            try {
                JdtRenameTransaction tx = new JdtRenameTransaction();
                this.fillTransaction(tx, this.m_dialog.getNewName());
                tx.commit(ScoutSdkUi.getShell());
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("rename failed.", e);
            }
        }
        return null;
    }

    private void validateInternal(String newName) {
        IStatus status = this.validate(newName);
        this.m_dialog.getOkButton().setEnabled(true);
        switch (status.getSeverity()) {
            case 4: {
                this.m_dialog.setMessage(status.getMessage(), 3);
                this.m_dialog.getOkButton().setEnabled(false);
                break;
            }
            case 2: {
                this.m_dialog.setMessage(status.getMessage(), 2);
                break;
            }
            case 1: {
                this.m_dialog.setMessage(status.getMessage(), 1);
                break;
            }
            default: {
                this.m_dialog.setMessage("", 0);
            }
        }
    }

    @Override
    public boolean canRun(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof AbstractScoutTypePage) {
            AbstractScoutTypePage astp = (AbstractScoutTypePage)selectedElement;
            this.m_oldName = astp.getType().getElementName();
            this.m_readOnlySuffix = astp.getReadOnlySuffix();
            return true;
        }
        if (selectedElement instanceof SharedContextPropertyNodePage) {
            SharedContextPropertyNodePage scpnp = (SharedContextPropertyNodePage)selectedElement;
            IPropertyBean serverDesc = scpnp.getServerDesc();
            if (serverDesc != null) {
                this.m_oldName = serverDesc.getBeanName();
                return true;
            }
            IPropertyBean clientDesc = scpnp.getClientDesc();
            if (clientDesc != null) {
                this.m_oldName = clientDesc.getBeanName();
                return true;
            }
        } else if (selectedElement instanceof BeanPropertyNodePage) {
            BeanPropertyNodePage bpnp = (BeanPropertyNodePage)selectedElement;
            this.m_oldName = bpnp.getPropertyDescriptor().getBeanName();
            return true;
        }
        return false;
    }

    protected abstract void fillTransaction(JdtRenameTransaction var1, String var2) throws CoreException;

    protected abstract IStatus validate(String var1);

    public String getOldName() {
        return this.m_oldName;
    }

    public void setOldName(String newOldName) {
        this.m_oldName = newOldName;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }
}

