/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.security.Permission;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.AbstractWorkspaceBlockingJob;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FormDeleteExecutor
extends AbstractExecutor {
    private IType m_formType;
    private IType m_formData;
    private Set<IType> m_processServiceInterface;
    private Set<IType> m_processServiceImplementation;
    private MemberSelectionDialog m_confirmDialog;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_formType = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_formType);
    }

    @Override
    public Object run(final Shell shell, final IStructuredSelection selection, final ExecutionEvent event) {
        new AbstractWorkspaceBlockingJob("Collect elements to delete"){

            protected void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
                FormDeleteExecutor.this.runAsync(shell, selection, event);
            }
        }.schedule();
        return null;
    }

    protected void runAsync(final Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        final LinkedHashSet<IMember> members = new LinkedHashSet<IMember>();
        final LinkedHashSet<IMember> selectedMembers = new LinkedHashSet<IMember>();
        this.collectAffectedMembers(members, selectedMembers, selection);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FormDeleteExecutor.this.m_confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"Action_deleteTypeX", (String[])new String[]{FormDeleteExecutor.this.m_formType.getElementName()}));
                FormDeleteExecutor.this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
                FormDeleteExecutor.this.m_confirmDialog.setMembers(members);
                FormDeleteExecutor.this.m_confirmDialog.setSelectedMembers(selectedMembers);
                if (FormDeleteExecutor.this.m_confirmDialog.open() == 0) {
                    JavaElementDeleteOperation op = new JavaElementDeleteOperation(){

                        protected void deleteMember(IJavaElement member, Set<ICompilationUnit> icuForOrganizeImports, IProgressMonitor m, IWorkingCopyManager mgr) throws CoreException {
                            if (member instanceof IType && FormDeleteExecutor.this.m_processServiceInterface.contains(member)) {
                                ScoutUtility.unregisterServiceProxy((IType)((IType)member));
                            }
                            if (member instanceof IType && FormDeleteExecutor.this.m_processServiceImplementation.contains(member)) {
                                ScoutUtility.unregisterServiceImplementation((IType)((IType)member));
                            }
                            super.deleteMember(member, icuForOrganizeImports, m, mgr);
                        }
                    };
                    op.setMembers(FormDeleteExecutor.this.m_confirmDialog.getSelectedMembers());
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        });
    }

    protected void collectAffectedMembers(Set<IMember> members, Set<IMember> selectedMembers, IStructuredSelection selection) {
        members.add((IMember)this.m_formType);
        selectedMembers.add((IMember)this.m_formType);
        try {
            this.m_formData = ScoutTypeUtility.findDtoForForm((IType)this.m_formType);
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError(e);
        }
        if (TypeUtility.exists((IJavaElement)this.m_formData)) {
            members.add((IMember)this.m_formData);
            selectedMembers.add((IMember)this.m_formData);
        }
        String formName = this.m_formType.getElementName().replaceAll("^(.*)Form$", "$1");
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
        this.m_processServiceInterface = TypeUtility.getInterfacesOnClasspath((IType)iService, (IJavaProject)this.m_formType.getJavaProject(), (ITypeFilter)TypeFilters.getRegexSimpleNameFilter((String)("I" + formName + "(Process)?" + "Service"), (int)0));
        members.addAll(this.m_processServiceInterface);
        this.m_processServiceImplementation = new HashSet<IType>();
        for (IType serviceInterface : this.m_processServiceInterface) {
            Set implementations = TypeUtility.getPrimaryTypeHierarchy((IType)serviceInterface).getAllSubtypes(serviceInterface, TypeFilters.getClassFilter(), TypeComparators.getTypeNameComparator());
            this.m_processServiceImplementation.addAll(implementations);
        }
        members.addAll(this.m_processServiceImplementation);
        String permissionRegex = this.m_formType.getElementName().replaceAll("^(.*)Form$", "(Create|Read|Update)$1Permission");
        IType permission = TypeUtility.getType((String)Permission.class.getName());
        Set permissions = TypeUtility.getClassesOnClasspath((IType)permission, (IJavaProject)this.m_formType.getJavaProject(), (ITypeFilter)TypeFilters.getRegexSimpleNameFilter((String)permissionRegex, (int)0));
        members.addAll(permissions);
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(Set<? extends IMember> selection) {
            FormDeleteExecutor.this.m_confirmDialog.setMessage("");
            boolean canOk = true;
            if (selection == null || selection.size() == 0) {
                canOk = false;
            } else if (FormDeleteExecutor.this.m_formType != null && FormDeleteExecutor.this.m_formData != null && selection.contains(FormDeleteExecutor.this.m_formType) != selection.contains(FormDeleteExecutor.this.m_formData)) {
                FormDeleteExecutor.this.m_confirmDialog.setMessage(Texts.get((String)"FormDataDeleteWithForm", (String[])new String[]{FormDeleteExecutor.this.m_formData.getElementName()}), 2);
            }
            FormDeleteExecutor.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

