/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.library.LibraryBundleUnlinkOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibraryNodePage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.widgets.Shell;

public class LibrariesBundleUnlinkExecutor
extends AbstractExecutor {
    private Map<IScoutBundle, List<IPluginModelBase>> m_toUnlink;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_toUnlink = new HashMap<IScoutBundle, List<IPluginModelBase>>(selection.size());
        for (Object o : selection) {
            LibraryNodePage lnp;
            IScoutBundle scoutBundle;
            if (!(o instanceof LibraryNodePage) || (scoutBundle = (lnp = (LibraryNodePage)o).getScoutBundle()).isBinary()) continue;
            List<IPluginModelBase> list = this.m_toUnlink.get(scoutBundle);
            if (list == null) {
                list = new LinkedList<IPluginModelBase>();
                this.m_toUnlink.put(scoutBundle, list);
            }
            list.add(lnp.getPluginModel());
        }
        return this.m_toUnlink.size() > 0;
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        OperationJob job = new OperationJob();
        for (Map.Entry<IScoutBundle, List<IPluginModelBase>> workUnit : this.m_toUnlink.entrySet()) {
            LibraryBundleUnlinkOperation op = new LibraryBundleUnlinkOperation(workUnit.getKey(), (Collection)workUnit.getValue());
            job.addOperation((IOperation)op);
        }
        job.schedule();
        return null;
    }
}

