/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.sql;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.beans.FastBeanUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.sql.SqlBindProposal;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.swt.graphics.Image;

public class SqlBindCompletionProposalProcessor {
    private final Image m_image = ScoutSdkUi.getImage("default.gif");
    private static final Pattern REGEX_QUOTES = Pattern.compile("\\\"");
    private static final Pattern REGEX_BIND = Pattern.compile(".*\\:[A-Za-z0-9\\._-]*$");

    public List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            SqlBindProposal prop;
            String propName;
            if (!SqlBindCompletionProposalProcessor.isSqlStatementLocation(context.getViewer(), context.getInvocationOffset())) {
                return Collections.emptyList();
            }
            IType formData = this.getFormDataParameterType(context);
            if (formData == null || !formData.exists()) {
                return Collections.emptyList();
            }
            IType abstractFormFieldData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData");
            IType abstractPropertyData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData");
            if (!TypeUtility.exists((IJavaElement)abstractPropertyData) || !TypeUtility.exists((IJavaElement)abstractFormFieldData)) {
                return Collections.emptyList();
            }
            String prefix = SqlBindCompletionProposalProcessor.getPrefix(context.getViewer(), context.getInvocationOffset());
            HashSet<ICompletionProposal> collector = new HashSet<ICompletionProposal>();
            ITypeHierarchy hierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{formData});
            for (IType t : TypeUtility.getInnerTypes((IType)formData, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)abstractFormFieldData, (ITypeHierarchy)hierarchy))) {
                propName = FastBeanUtility.decapitalize((String)NamingUtility.ensureStartWithUpperCase((String)t.getElementName()));
                prop = new SqlBindProposal(propName, prefix, context.getInvocationOffset(), this.m_image);
                collector.add(prop);
                this.addInnerTypesInSuperClasses(t, TypeUtility.getSupertypeHierarchy((IType)t), collector, prefix, String.valueOf(propName) + ".", context);
            }
            for (IType t : TypeUtility.getInnerTypes((IType)formData, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)abstractPropertyData, (ITypeHierarchy)hierarchy))) {
                propName = NamingUtility.ensureStartWithUpperCase((String)t.getElementName());
                propName = FastBeanUtility.decapitalize((String)propName.replaceAll("Property$", ""));
                prop = new SqlBindProposal(propName, prefix, context.getInvocationOffset(), this.m_image);
                collector.add(prop);
            }
            TreeMap<String, ICompletionProposal> sorted = new TreeMap<String, ICompletionProposal>();
            for (ICompletionProposal p : collector) {
                if (!p.getDisplayString().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                sorted.put(p.getDisplayString(), p);
            }
            return CollectionUtility.arrayList(sorted.values());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("error while creating sql completion.", e);
            return Collections.emptyList();
        }
    }

    private void addInnerTypesInSuperClasses(IType baseType, ITypeHierarchy baseTypeSuperHierarchy, HashSet<ICompletionProposal> collector, String prefix, String namePrefix, JavaContentAssistInvocationContext context) throws JavaModelException {
        IType abstractFormFieldData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData");
        for (IType superClass : baseTypeSuperHierarchy.getSuperClassStack(baseType, false)) {
            ITypeHierarchy hierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{superClass});
            for (IType innerType : TypeUtility.getInnerTypes((IType)superClass, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)abstractFormFieldData, (ITypeHierarchy)hierarchy))) {
                SqlBindProposal prop = new SqlBindProposal(String.valueOf(namePrefix) + FastBeanUtility.decapitalize((String)NamingUtility.ensureStartWithUpperCase((String)innerType.getElementName())), prefix, context.getInvocationOffset(), this.m_image);
                collector.add(prop);
                this.addInnerTypesInSuperClasses(innerType, TypeUtility.getSupertypeHierarchy((IType)innerType), collector, prefix, String.valueOf(prop.getDisplayString()) + ".", context);
            }
        }
    }

    private static boolean isSqlStatementLocation(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return false;
        }
        IRegion lineInfo = doc.getLineInformationOfOffset(offset);
        String linePart = doc.get(lineInfo.getOffset(), offset - lineInfo.getOffset());
        Matcher m = REGEX_QUOTES.matcher(linePart);
        boolean stringLocation = false;
        while (m.find()) {
            boolean bl = stringLocation = !stringLocation;
        }
        if (stringLocation) {
            stringLocation = REGEX_BIND.matcher(linePart).matches();
        }
        return stringLocation;
    }

    private IType getFormDataParameterType(JavaContentAssistInvocationContext context) throws CoreException {
        IJavaElement element;
        IType abstractFormData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData");
        if (TypeUtility.exists((IJavaElement)abstractFormData) && (element = context.getCoreContext().getEnclosingElement()).getElementType() == 9) {
            IMethod method = (IMethod)element;
            String[] stringArray = method.getParameterTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeHierarchy supertypeHierarchy;
                IType candidate;
                String parameter = stringArray[n2];
                String fqs = SignatureUtility.getResolvedSignature((String)parameter, (IType)method.getDeclaringType());
                if (SignatureUtility.getTypeSignatureKind((String)fqs) == 1 && TypeUtility.exists((IJavaElement)(candidate = TypeUtility.getTypeBySignature((String)fqs))) && (supertypeHierarchy = TypeUtility.getSupertypeHierarchy((IType)candidate)) != null && supertypeHierarchy.contains(abstractFormData)) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && (Character.isLetterOrDigit(doc.getChar(offset)) || doc.getChar(offset) == '.' || doc.getChar(offset) == '_' || doc.getChar(offset) == '-')) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }
}

