/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.fields.table;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.scout.sdk.ui.internal.fields.table.AbstractColumnProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeColumnProvider
extends AbstractColumnProvider {
    private final TreeViewer m_viewer;
    private Listener m_listener = new P_ControlListener();

    public TreeColumnProvider(TreeViewer viewer) {
        this.m_viewer = viewer;
        this.attachListeners();
    }

    private void attachListeners() {
        this.m_viewer.getTree().getHorizontalBar().addListener(13, this.m_listener);
        TreeColumn[] treeColumnArray = this.m_viewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            col.addListener(11, this.m_listener);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        this.m_viewer.getTree().getHorizontalBar().removeListener(13, this.m_listener);
    }

    public TreeViewer getViewer() {
        return this.m_viewer;
    }

    @Override
    public void expandAll() {
        this.getViewer().expandAll();
    }

    @Override
    public int getColumnCount() {
        return this.getViewer().getTree().getColumnCount();
    }

    @Override
    public Object[] getChildren(Object node) {
        return ((ITreeContentProvider)this.getViewer().getContentProvider()).getChildren(node);
    }

    @Override
    public String getCellText(Object element, int columnIndex) {
        IBaseLabelProvider provider = this.getViewer().getLabelProvider();
        if (provider instanceof ITableLabelProvider) {
            return ((ITableLabelProvider)provider).getColumnText(element, columnIndex);
        }
        return "";
    }

    @Override
    public int[] getColumnWidths() {
        TreeColumn[] columns = this.getViewer().getTree().getColumns();
        int[] widths = new int[columns.length];
        int i = 0;
        while (i < columns.length) {
            widths[i] = columns[i].getWidth();
            ++i;
        }
        return widths;
    }

    @Override
    public int getXOffset() {
        int offset = -this.getViewer().getTree().getHorizontalBar().getSelection();
        return offset;
    }

    private class P_ControlListener
    implements Listener {
        private P_ControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    if (!(event.widget instanceof ScrollBar)) break;
                    TreeColumnProvider.this.scheduleUpdateLayout();
                    break;
                }
                case 11: {
                    TreeColumnProvider.this.scheduleUpdateLayout();
                }
            }
        }
    }
}

