/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.action.ExportScoutProjectAction;
import org.eclipse.scout.sdk.ui.action.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ClassIdNewAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutBundleNewAction;
import org.eclipse.scout.sdk.ui.action.dto.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverPageDataAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerSettingsSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNodeGroup;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class BundleNodeGroupTablePage
extends AbstractPage {
    private ScoutBundleNodeGroup m_group;

    public BundleNodeGroupTablePage(AbstractPage parentPage, ScoutBundleNodeGroup group) {
        this.m_group = group;
        this.setParent(parentPage);
        this.setName(group.getGroupName());
        ImageDescriptor icon = ScoutSdkUi.getImageDescriptor("projectGroup.png");
        if (group.isBinary()) {
            icon = ScoutSdkUi.getImageDescriptor(icon, "binary_decoration.png", 2);
        }
        this.setImageDescriptor(icon);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.BundleNodeGroupTablePage";
    }

    @Override
    public int getOrder() {
        return 10000;
    }

    @Override
    public IScoutBundle getScoutBundle() {
        return this.m_group.getDefiningBundle().getScoutBundle();
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(MultipleUpdateFormDataAction.class, TypeResolverPageDataAction.class, FormDataSqlBindingValidateAction.class, ExportScoutProjectAction.class, ScoutBundleNewAction.class, WellformAction.class, ClassIdNewAction.class);
    }

    @Override
    protected void loadChildrenImpl() {
        for (ScoutBundleNode b : this.m_group.getChildBundles()) {
            b.createBundlePage(this);
        }
        if (ScoutExplorerSettingsSupport.BundlePresentation.GROUPED.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            Object[] childGroups = this.m_group.getChildGroups().toArray(new ScoutBundleNodeGroup[this.m_group.getChildGroups().size()]);
            Arrays.sort(childGroups);
            Object[] objectArray = childGroups;
            int n = childGroups.length;
            int n2 = 0;
            while (n2 < n) {
                Object childGroup = objectArray[n2];
                new BundleNodeGroupTablePage(this, (ScoutBundleNodeGroup)childGroup);
                ++n2;
            }
        }
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash += 31 * hash + this.m_group.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (!equals) {
            return false;
        }
        if (!(obj instanceof BundleNodeGroupTablePage)) {
            return false;
        }
        return CompareUtility.equals((Object)this.m_group, (Object)((BundleNodeGroupTablePage)obj).m_group);
    }
}

