/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.create.CodeNewAction;
import org.eclipse.scout.sdk.ui.action.delete.DeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;

public class CodeNodePage
extends AbstractScoutTypePage {
    private InnerTypePageDirtyListener m_innerTypeListener;

    public CodeNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setType(type);
        this.setName(PropertyMethodSourceUtility.getTranslatedMethodStringValue((IType)this.getType(), (String)"getConfiguredText"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("code.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CodeNodePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_innerTypeListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
            this.m_innerTypeListener = null;
        }
    }

    @Override
    protected void loadChildrenImpl() {
        if (this.m_innerTypeListener == null) {
            IType iCode = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode");
            this.m_innerTypeListener = new InnerTypePageDirtyListener(this, iCode);
            ScoutSdkCore.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
        }
        Set codes = ScoutTypeUtility.getCodes((IType)this.getType());
        for (IType code : codes) {
            new CodeNodePage(this, code);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(TypeRenameAction.class, ShowJavaReferencesAction.class, CodeNewAction.class, DeleteAction.class);
    }
}

