/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiMethodPresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodBean;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.scout.sdk.workspace.type.config.parser.BooleanPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultiBooleanPresenter
extends AbstractMultiMethodPresenter<Boolean> {
    private Button m_checkbox;

    public MultiBooleanPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        this.m_checkbox = this.getToolkit().createButton(container, "", 32);
        this.m_checkbox.setEnabled(false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiBooleanPresenter.this.storeMethods(MultiBooleanPresenter.this.getMethodBeans());
            }
        };
        this.m_checkbox.addSelectionListener((SelectionListener)listener);
        return this.m_checkbox;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_checkbox.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_checkbox.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void init(ConfigurationMethodSet methodSet) throws CoreException {
        super.init(methodSet);
        Collection methodBeans = this.getMethodBeans();
        if (!MultiBooleanPresenter.allEqual(methodBeans)) {
            this.m_checkbox.setText("###");
            this.m_checkbox.setForeground(this.m_checkbox.getDisplay().getSystemColor(15));
        } else {
            this.m_checkbox.setText("");
            this.m_checkbox.setForeground(null);
            this.m_checkbox.setSelection(((Boolean)methodBeans.iterator().next().getCurrentSourceValue()).booleanValue());
        }
        this.m_checkbox.setEnabled(true);
    }

    @Override
    protected Boolean parseDisplayInput(String value) throws CoreException {
        return this.m_checkbox.getSelection();
    }

    @Override
    protected Boolean parseSourceInput(String value, ConfigurationMethod method) throws CoreException {
        Boolean bool = PropertyMethodSourceUtility.parseReturnParameterBoolean((String)value, (IMethod)method.peekMethod(), (ITypeHierarchy)method.getSuperTypeHierarchy());
        return bool;
    }

    @Override
    protected String formatDisplayValue(Boolean value) throws CoreException {
        return "";
    }

    @Override
    protected String formatSourceValue(Boolean value) throws CoreException {
        return Boolean.toString(value);
    }

    protected synchronized void storeMethods(Collection<MethodBean<Boolean>> beans) {
        ArrayList<ConfigPropertyUpdateOperation> list = new ArrayList<ConfigPropertyUpdateOperation>(beans.size());
        for (MethodBean<Boolean> bean : beans) {
            ConfigurationMethod method = bean.getMethod();
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(method, (IPropertySourceParser)new BooleanPropertySourceParser());
            updateOp.setValue((Object)this.m_checkbox.getSelection());
            list.add(updateOp);
        }
        new OperationJob(list).schedule();
    }
}

