/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.DoublePropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class DoublePresenter
extends AbstractValuePresenter<Double> {
    private final IPropertySourceParser<Double> m_parser = new DoublePropertySourceParser();
    private final NumberFormat m_formatter = DecimalFormat.getInstance(Locale.ENGLISH);

    public DoublePresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[\\-\\+0-9\\.\\'eEinfdFD]*");
        this.m_formatter.setMaximumFractionDigits(20);
    }

    public IPropertySourceParser<Double> getParser() {
        return this.m_parser;
    }

    @Override
    protected String formatDisplayValue(Double value) throws CoreException {
        if (value == null) {
            return "";
        }
        if (value == Double.MAX_VALUE) {
            return "inf";
        }
        if (value == -1.7976931348623157E308) {
            return "-inf";
        }
        return this.m_formatter.format(value);
    }

    @Override
    protected Double parseSourceInput(String input) throws CoreException {
        return this.parseDisplayInput(input);
    }

    @Override
    protected Double parseDisplayInput(String input) throws CoreException {
        if ("".equals(input)) {
            return (Double)this.getDefaultValue();
        }
        return (Double)this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected synchronized void storeValue(Double value) throws CoreException {
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.getParser());
            updateOp.setValue((Object)value);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }
}

