/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BundleTreeWizardPage
extends AbstractWorkspaceWizardPage {
    private CheckableTree m_tree;
    private boolean m_treeListenersAttached = false;
    private final ITreeNode m_rootNode;
    private final List<ITreeDndListener> m_tempDndListeners;
    private final List<ICheckStateListener> m_tempCheckListeners;
    private final ITreeNodeFilter m_initialCheckedFilter;

    public BundleTreeWizardPage(String pageTitle, String message, ITreeNode rootNode, ITreeNodeFilter initialCheckedFilter) {
        super(BundleTreeWizardPage.class.getName());
        this.m_rootNode = rootNode;
        this.m_tempDndListeners = new ArrayList<ITreeDndListener>();
        this.m_tempCheckListeners = new ArrayList<ICheckStateListener>();
        this.setDescription(message);
        this.setTitle(pageTitle);
        if (initialCheckedFilter == null) {
            initialCheckedFilter = NodeFilters.getAcceptNone();
        }
        this.m_initialCheckedFilter = initialCheckedFilter;
    }

    public synchronized void addCheckSelectionListener(ICheckStateListener listener) {
        if (this.m_treeListenersAttached) {
            this.m_tree.addCheckSelectionListener(listener);
        } else {
            this.m_tempCheckListeners.add(listener);
        }
    }

    public synchronized void removeCheckSelectionListener(ICheckStateListener listener) {
        if (this.m_treeListenersAttached) {
            this.m_tree.removeCheckSelectionListener(listener);
        } else {
            this.m_tempCheckListeners.remove(listener);
        }
    }

    public synchronized void addDndListener(ITreeDndListener listener) {
        if (this.m_treeListenersAttached) {
            this.m_tree.addDndListener(listener);
        } else {
            this.m_tempDndListeners.add(listener);
        }
    }

    public synchronized void removeDndListener(ITreeDndListener listener) {
        if (this.m_treeListenersAttached) {
            this.m_tree.removeDndListener(listener);
        } else {
            this.m_tempDndListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createContent(Composite parent) {
        this.m_tree = new CheckableTree(parent, this.getRootNode());
        this.m_tree.setChecked(TreeUtility.findNodes(this.getRootNode(), this.m_initialCheckedFilter));
        BundleTreeWizardPage bundleTreeWizardPage = this;
        synchronized (bundleTreeWizardPage) {
            for (ITreeDndListener iTreeDndListener : this.m_tempDndListeners) {
                this.m_tree.addDndListener(iTreeDndListener);
            }
            this.m_tempDndListeners.clear();
            this.m_tree.addDndListener(new ITreeDndListener(){

                @Override
                public void validateTarget(DndEvent dndEvent) {
                }

                @Override
                public boolean isDragableNode(ITreeNode node) {
                    return true;
                }

                @Override
                public void dndPerformed(DndEvent dndEvent) {
                    BundleTreeWizardPage.this.pingStateChanging();
                }
            });
            for (ICheckStateListener iCheckStateListener : this.m_tempCheckListeners) {
                this.m_tree.addCheckSelectionListener(iCheckStateListener);
            }
            this.m_tempCheckListeners.clear();
            this.m_tree.addCheckSelectionListener(new ICheckStateListener(){

                @Override
                public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                    BundleTreeWizardPage.this.pingStateChanging();
                }
            });
            this.m_treeListenersAttached = true;
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData interfaceLocationData = new GridData(1808);
        interfaceLocationData.heightHint = 200;
        this.m_tree.setLayoutData(interfaceLocationData);
    }

    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    private CheckableTree getTree() {
        return this.m_tree;
    }

    public void refreshTree() {
        if (this.isControlCreated()) {
            this.m_tree.getTreeViewer().refresh();
        }
    }

    public IScoutBundle[] getLocationBundles(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode[] nodes = this.getTreeNodes(type, visibleOnly, checkedOnly);
        ArrayList<IScoutBundle> result = new ArrayList<IScoutBundle>();
        ITreeNode[] iTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            if (node != null && node.getParent() != null && node.getParent().getData() instanceof IScoutBundle) {
                result.add((IScoutBundle)node.getParent().getData());
            }
            ++n2;
        }
        return result.toArray(new IScoutBundle[result.size()]);
    }

    public ITreeNode[] getTreeNodes(String type, boolean visibleOnly, boolean checkedOnly) {
        ArrayList<ITreeNode> result = new ArrayList<ITreeNode>();
        if (this.isControlCreated()) {
            ITreeNode[] nodes;
            ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_rootNode, NodeFilters.getByType(type));
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode node = iTreeNodeArray[n2];
                if (!(node != null && checkedOnly && node.isCheckable() && !this.getTree().isChecked(node) || node != null && visibleOnly && !node.isVisible())) {
                    result.add(node);
                }
                ++n2;
            }
        }
        return result.toArray(new ITreeNode[result.size()]);
    }

    public static IScoutBundle getLocationBundle(ITreeNode node) {
        ITreeNode searchNode = node;
        Object bundle = null;
        while (bundle == null && searchNode != null) {
            Object o = searchNode.getData();
            if (o instanceof IScoutBundle) {
                return (IScoutBundle)o;
            }
            searchNode = searchNode.getParent();
        }
        return null;
    }

    public IScoutBundle getLocationBundle(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode node = this.getTreeNode(type, visibleOnly, checkedOnly);
        return BundleTreeWizardPage.getLocationBundle(node);
    }

    public ITreeNode getTreeNode(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode node = null;
        if (this.isControlCreated() && (node = TreeUtility.findNode(this.m_rootNode, NodeFilters.getByType(type))) != null) {
            if (node.isCheckable() && checkedOnly && !this.getTree().isChecked(node)) {
                return null;
            }
            if (visibleOnly && !node.isVisible()) {
                return null;
            }
        }
        return node;
    }

    public String getTextOfNode(String nodeType) {
        return this.getTextOfNode(nodeType, true, true);
    }

    public String getTextOfNode(String type, boolean visibleOnly, boolean checkedOnly) {
        ITreeNode treeNode = this.getTreeNode(type, visibleOnly, checkedOnly);
        String text = null;
        if (treeNode != null) {
            text = treeNode.getText();
        }
        return text;
    }

    public boolean isNodeChecked(ITreeNode node) {
        return this.m_tree.isChecked(node);
    }

    public void setNodeChecked(ITreeNode node, boolean checked) {
        this.m_tree.setChecked(node, checked);
    }
}

