/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.util.ast.AstUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.jdt.finegrained.AbstractFineGrainedAstMatcher;

public class JdtEventCollector {
    private final ICompilationUnit m_icu;
    private final Map<IJavaElement, JdtEvent> m_events;
    private long m_lastModification;
    private CompilationUnit m_ast;

    JdtEventCollector(ICompilationUnit icu) {
        this.m_icu = icu;
        this.m_lastModification = icu.getResource().getModificationStamp();
        this.m_events = new HashMap<IJavaElement, JdtEvent>();
        this.m_ast = this.createAst();
    }

    private CompilationUnit createAst() {
        ASTParser parser = AstUtility.newParser();
        parser.setCompilerOptions((Map)JavaCore.getOptions());
        parser.setKind(8);
        parser.setSource(this.m_icu);
        return (CompilationUnit)parser.createAST(null);
    }

    public Set<IJavaElement> updateAst() {
        final CompilationUnit newAst = this.createAst();
        final HashSet<IJavaElement> set = new HashSet<IJavaElement>();
        AbstractFineGrainedAstMatcher matcher = new AbstractFineGrainedAstMatcher(){

            @Override
            protected boolean processDelta(boolean match, ASTNode node, Object other) {
                if (!match) {
                    try {
                        IJavaElement e;
                        IJavaElement javaElement = newAst.getJavaElement();
                        if (javaElement instanceof ICompilationUnit && (e = ((ICompilationUnit)javaElement).getElementAt(node.getStartPosition())) != null) {
                            set.add(e);
                        }
                    }
                    catch (JavaModelException e1) {
                        SdkUtilActivator.logError(e1);
                    }
                }
                return true;
            }
        };
        newAst.subtreeMatch((ASTMatcher)matcher, (Object)this.m_ast);
        this.m_ast = newAst;
        return set;
    }

    public void addEvent(JdtEvent e) {
        this.m_events.put(e.getElement(), e);
    }

    public boolean containsEventFor(IJavaElement element) {
        return this.m_events.containsKey(element);
    }

    public boolean hasEvents() {
        return !this.m_events.isEmpty();
    }

    public List<JdtEvent> removeAllEvents(long resourceTimestamp) {
        ArrayList values = CollectionUtility.arrayList(this.m_events.values());
        this.m_events.clear();
        this.m_lastModification = resourceTimestamp;
        return values;
    }

    public boolean isEmpty() {
        return this.m_events.size() == 0;
    }

    public long getLastModification() {
        return this.m_lastModification;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.m_icu;
    }

    public CompilationUnit getAst() {
        return this.m_ast;
    }
}

