/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.resource.ManagedResource;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.w3c.dom.Document;

public class XmlResource
extends ManagedResource {
    private Document m_xmlDocument;

    public XmlResource(IScoutBundle bundle) {
        super(bundle.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document loadXml() {
        Object object = this.m_fileLock;
        synchronized (object) {
            block20: {
                block18: {
                    if (this.existsFile()) break block18;
                    this.m_xmlDocument = null;
                    return null;
                }
                if (this.m_xmlDocument == null || this.m_file.getModificationStamp() != this.m_modificationStamp) {
                    this.m_xmlDocument = null;
                    this.m_modificationStamp = this.m_file.getModificationStamp();
                    InputStream is = null;
                    try {
                        try {
                            is = this.m_file.getContents();
                            this.m_xmlDocument = JaxWsSdkUtility.createNewXmlDocument(is);
                        }
                        catch (Exception e) {
                            JaxWsSdk.logWarning("Failed to parse XML file '" + this.m_file.getName() + "'.", e);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this.m_xmlDocument;
    }

    public void storeXmlAsync(final Document xmlDocument, final int notificationEvent, final String ... notificationElements) {
        IOperation op = new IOperation(){

            public void validate() {
            }

            public String getOperationName() {
                return "Store resource to disk";
            }

            public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
                XmlResource.this.storeXml(xmlDocument, notificationEvent, monitor, notificationElements);
            }
        };
        new OperationJob(new IOperation[]{op}).schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeXml(Document xmlDocument, int notificationEvent, IProgressMonitor monitor, String ... notificationElements) throws CoreException {
        try {
            Object object = this.m_fileLock;
            synchronized (object) {
                if (this.m_file == null) {
                    throw new CoreException((IStatus)new ScoutStatus("File must not be null"));
                }
                String xmlContent = JaxWsSdkUtility.getXmlContent(xmlDocument);
                this.m_modificationStamp = Integer.MAX_VALUE;
                try {
                    JaxWsSdkUtility.ensureFileAccessibleAndRegistered(this.m_file, true);
                    this.m_file.setContents((InputStream)new ByteArrayInputStream(xmlContent.getBytes("UTF-8")), true, true, monitor);
                    this.m_xmlDocument = xmlDocument;
                }
                finally {
                    this.m_modificationStamp = this.m_file.getModificationStamp();
                }
            }
            String[] stringArray = notificationElements;
            int n = notificationElements.length;
            int n2 = 0;
            while (n2 < n) {
                String notificationElement = stringArray[n2];
                this.notifyResourceListeners(notificationElement, notificationEvent);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new ScoutStatus(4, "Failed to persist XML file.", (Throwable)e));
        }
    }
}

